#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#define DB_DEPLOY
#define DB_SPECIAL

#include <QtCore/QFileInfoList>

#include <QtGui/QWidget>
#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QPushButton>
#include <QtGui/QTabWidget>

#include <QtGui/QGridLayout>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QSpacerItem>
#include <QtGui/QCheckBox>
#include <QtGui/QCloseEvent>
#include <QtGui/QPlainTextEdit>
#include <QtGui/QTimeEdit>
#include <QtGui/QDateEdit>
#include <QtGui/QComboBox>
#include <QtGui/QSplitter>
#include <QtGui/QDoubleSpinBox>
#include <QtGui/QRadioButton>

#include "../../CrossPlatform/ConferenceDB.h"
#include "../../CrossPlatform/CSFParser.h"

#include "QElemList.h"

#define VERSION "1.25"

class MainWindow : public QWidget
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    virtual void closeEvent(QCloseEvent *event);

private:
    QVBoxLayout *m_globalLayout;
    QHBoxLayout* m_ButtonLayout;
    QTabWidget *m_globalTabs;

    QWidget* m_tabGeneral;
    QWidget* m_tabAffiliations;
    QWidget* m_tabPeople;
    QWidget* m_tabPublications;
    QWidget* m_tabTalks;
    QWidget* m_tabBuildings;
    QWidget* m_tabRooms;
    QWidget* m_tabSessions;
    QWidget* m_tabTracks;
    QWidget* m_tabDays;

    QPushButton* m_New;
    QPushButton* m_Demo;
    QPushButton* m_Cleanup;
    QPushButton* m_Open;
    QPushButton* m_Save;
    QPushButton* m_SaveAs;
#ifdef DB_DEPLOY
    QPushButton* m_Deploy;
#endif
#ifdef DB_SPECIAL
    QPushButton* m_Special;
#endif
    QPushButton* m_Quit;

    bool eventFilter( QObject* watched, QEvent* event );

    void setupUi();
    void setupDataTabs();

    // general tab
    QGridLayout *m_gridLayoutGeneral;
    QLabel *m_ConfNameLabel;
    QLineEdit *m_ConfNameEdit;
    QLabel *m_ShortNameLabel;
    QLineEdit *m_ShortNameEdit;
    QLabel *m_ContactEmailLabel;
    QLineEdit *m_ContactEmailEdit;
    QLabel *m_WebUrlLabel;
    QLineEdit *m_WebUrlEdit;
    QLabel *m_NewsUrlLabel;
    QLineEdit *m_NewsUrlEdit;
    QLabel *m_TwitterNameLabel;
    QLineEdit *m_TwitterNameEdit;
    QCheckBox *m_SupportsSessionMails;
    QSpacerItem *m_verticalSpacerGeneral;
    void UpdateGeneralUI();
    void setupGeneralTab();

    // affiliations tab
    QHBoxLayout *m_AffGlobalLayout;
    QFrame * m_AffListFrame;
    QGridLayout *m_gridLayoutAffList;
    QPushButton* m_AffImportBtn;
    QElemList *m_AffList;
    QSplitter* m_AffSplitter;
    QFrame *m_AffEditFrame;
    QGridLayout *m_gridLayoutAff;
    QLabel *m_AffNameLabel;
    QLineEdit *m_AffNameEdit;
    QLabel *m_AffAddressLabel;
    QLineEdit *m_AffAddressEdit;
    QSpacerItem *m_AffEditSpacer;
    void UpdateAffUI(index_t newIndex=INDEX_EMPTY);
    void setupAffiliationsTab();

    // people tab
    QHBoxLayout *m_PeopleGlobalLayout;
    QElemList *m_PeopleList;
    QFrame * m_PeopleListFrame;
    QGridLayout *m_gridLayoutPeopleList;
    QPushButton* m_PeopleImportBtn;
    QPushButton* m_PeopleMailBtn;
    QPushButton* m_ClearButton;
    QSplitter* m_PeopleSplitter;
    QFrame *m_PeopleEditFrame;
    QGridLayout *m_gridLayoutPeople;
    QLabel *m_PeopleFirstnameLabel;
    QLineEdit *m_PeopleFirstnameEdit;
    QLabel *m_PeopleMiddlenameLabel;
    QLineEdit *m_PeopleMiddlenameEdit;
    QLabel *m_PeopleLastnameLabel;
    QLineEdit *m_PeopleLastnameEdit;
    QLabel *m_PeopleEmailLabel;
    QLineEdit *m_PeopleEmailEdit;
    QLabel *m_PeopleTwitterLabel;
    QLineEdit *m_PeopleTwitterEdit;
    QLabel *m_PeoplePictureURLLabel;
    QLineEdit *m_PeoplePictureURLEdit;
    QLabel *m_PeopleWebURLLabel;
    QLineEdit *m_PeopleWebURLEdit;
    QLabel *m_PeopleAffLabel;
    QElemList *m_PeopleAffList;
    QSpacerItem *m_PeopleEditSpacer;
    void UpdatePeopleUI(index_t newIndex=INDEX_EMPTY);
    void UpdatePeopleAffList();
    void UpdatePeopleAffList(index_t index);
    void setupPeopleTab();
    std::string PersonToString(const SciPerson* p);


    // Publication tab
    QHBoxLayout *m_PublicationGlobalLayout;
    QElemList *m_PublicationList;
    QSplitter* m_PublicationSplitter;
    QFrame * m_PublicationListFrame;
    QGridLayout *m_gridLayoutPublicationList;
    QPushButton* m_PublicationImportBtn;
    QFrame *m_PublicationEditFrame;
    QGridLayout *m_gridLayoutPublication;
    QLabel *m_PublicationTitleLabel;
    QLineEdit *m_PublicationTitleEdit;
    QLabel *m_PublicationAbstractLabel;
    QPlainTextEdit *m_PublicationAbstractEdit;
    QLabel *m_PublicationPreviewURLLabel;
    QLineEdit *m_PublicationPreviewURLEdit;
    QLabel *m_PublicationPDFURLabel;
    QLineEdit *m_PublicationPDFUREdit;
    QLabel *m_PublicationURLLabel;
    QLineEdit *m_PublicationURLEdit;
    QLabel *m_PublicationAuthorsLabel;
    QElemList *m_PublicationAuthorsList;
    QSpacerItem *m_PublicationEditSpacer;
    void UpdatePublicationUIEdits();
    void UpdatePublicationUI();
    void UpdatePublicationUI(index_t newIndex);
    void UpdatePublicationAuthorsList();
    void UpdatePublicationAuthorsList(index_t index);
    void setupPublicationsTab();

    // Talks Tab
    QHBoxLayout* m_TalkGlobalLayout;
    QElemList* m_TalkList;
    QSplitter* m_TalkSplitter;
    QFrame * m_TalkListFrame;
    QGridLayout *m_gridLayoutTalkList;
    QPushButton* m_TalkImportBtn;
    QPushButton* m_TalkTransferBtn;
    QFrame* m_TalkEditFrame;
    QGridLayout* m_gridLayoutTalk;
    QLabel* m_TalkTitleLabel;
    QLineEdit* m_TalkTitleEdit;
    QLabel* m_TalkStartTimeLabel;
    QTimeEdit* m_TalkStartTimeEdit;
    QLabel* m_TalkEndTimeLabel;
    QTimeEdit* m_TalkEndTimeEdit;
    QLabel* m_InvitedTalkAbstractLabel;
    QPlainTextEdit* m_InvitedTalkAbstractEdit;
    QLabel *m_TalkPaperLabel;
    QComboBox* m_TalkPaperComboBox;
    QLabel* m_TalkSpeakersLabel;
    QElemList* m_TalkSpeakersList;
    QSpacerItem* m_TalkEditSpacer;
    void UpdateTalksUIEdits();
    void UpdateTalksUI(index_t newIndex=INDEX_EMPTY);
    void UpdateTalksSpeakersList();
    void UpdateTalksSpeakersList(index_t index);
    void UpdateTalksPaperDropbox();
    void UpdateTalksPaperDropbox(index_t index);
    void setupTalksTab();

    // Buildings Tab
    QHBoxLayout* m_BuildingGlobalLayout;
    QElemList* m_BuildingList;
    QSplitter* m_BuildingSplitter;
    QFrame * m_BuildingListFrame;
    QGridLayout *m_gridLayoutBuildingList;
    QPushButton* m_BuildingImportBtn;
    QFrame* m_BuildingEditFrame;
    QGridLayout* m_gridLayoutBuilding;
    QLabel* m_BuildingNameLabel;
    QLineEdit* m_BuildingNameEdit;
    QLabel* m_BuildingLatitudeLabel;
    QDoubleSpinBox* m_BuildingLatitudeEdit;
    QLabel* m_BuildingLongitudeLabel;
    QDoubleSpinBox* m_BuildingLongitudeEdit;
    QSpacerItem* m_BuildingEditSpacer;
    QLabel* m_BuildingFloorplansLabel;
    QElemList* m_BuildingFloorplansList;
    QToolButton* m_BuildingShowOnMap;
    void setupBuildingsTab();
    void UpdateBuildingsFloorplans();
    void UpdateBuildingsFloorplans(index_t index);
    void UpdateBuildingsUI(index_t newIndex=INDEX_EMPTY);
    QPixmap m_BuildingImage;
    QString m_BuildingImagePath;
    void renderPosition();

    // Rooms
    QHBoxLayout* m_RoomGlobalLayout;
    QElemList* m_RoomList;
    QSplitter* m_RoomSplitter;
    QFrame* m_RoomEditFrame;
    QGridLayout* m_gridLayoutRoom;
    QLabel* m_RoomNameLabel;
    QLineEdit* m_RoomNameEdit;
    QLabel *m_RoomBuildingLabel;
    QComboBox* m_RoomBuildingComboBox;
    QLabel *m_RoomFloorIndexLabel;
    QComboBox* m_RoomFloorIndexComboBox;
    QLabel* m_RoomXLabel;
    QDoubleSpinBox* m_RoomXEdit;
    QLabel* m_RoomYLabel;
    QDoubleSpinBox* m_RoomYEdit;
    QLabel* m_MapImageLabel;
    QSpacerItem* m_RoomEditSpacer;
    void UpdateFloorImage(index_t index);
    void setupRoomsTab();
    void RoomsFillBuildingCB(index_t index);
    void RoomsFillFloorplanCB(index_t index);
    void RoomsFillCBoxes();
    void RoomsFillCBoxes(index_t index);
    void UpdateRoomsUI();
    void UpdateRoomsUI(index_t newIndex);

    // Sessions
    QHBoxLayout* m_SessionGlobalLayout;
    QElemList* m_SessionList;
    QSplitter* m_SessionSplitter;
    QFrame* m_SessionEditFrame;
    QGridLayout* m_gridLayoutSession;
    QLabel* m_SessionTypeLabel;
    QLineEdit* m_SessionTypeEdit;
    QLabel* m_SessionTitleLabel;
    QLineEdit* m_SessionTitleEdit;
    QLabel* m_SessionURLLabel;
    QLineEdit* m_SessionURLEdit;
    QLabel* m_SessionStartTimeLabel;
    QTimeEdit* m_SessionStartTimeEdit;
    QLabel* m_SessionEndTimeLabel;
    QTimeEdit* m_SessionEndTimeEdit;
    QLabel* m_SessionChairLabel;
    QComboBox* m_SessionChairComboBox;
    QCheckBox* m_SessionChairMailCheckBox;
    QLabel* m_SessionRoomsLabel;
    QElemList* m_SessionRoomsList;
    QLabel* m_PaperSessionTalksLabel;
    QElemList* m_PaperSessionTalksList;
    QLabel* m_PosterSessionPostersLabel;
    QElemList* m_PosterSessionPostersList;
    QSpacerItem* m_SessionEditSpacer;
    QRadioButton* m_sessionKeynoteRadioButton;
    QRadioButton* m_sessionCapstoneRadioButton;
    QLabel* m_InvitedSessionTalksLabel;
    QElemList* m_InvitedSessionTalksList;
    QLabel* m_OrganizedSessionAbstractLabel;
    QPlainTextEdit* m_OrganizedSessionAbstractEdit;
    QLabel* m_OrganizedSessionOrganizersLabel;
    QElemList* m_OrganizedSessionOrganizersList;
    QLabel* m_TutorialSessionTalksLabel;
    QElemList* m_TutorialSessionTalksList;
    QLabel* m_PanelSessionPanelistsLabel;
    QElemList* m_PanelSessionPanelistsList;
    void UpdateStartEnd();
    void UpdateStartEnd(index_t index);
    void SessionsFillChairCB();
    void SessionsFillChairCB(index_t index);
    void UpdateSessionLists();
    void UpdateSessionLists(index_t index);
    void setupSessionsTab();
    void UpdateSessionsUI(index_t newIndex=INDEX_EMPTY);

    // tracks
    QHBoxLayout* m_TrackGlobalLayout;
    QElemList* m_TrackList;
    QSplitter* m_TrackSplitter;
    QFrame * m_TrackListFrame;
    QGridLayout *m_gridLayoutTrackList;
    QPushButton* m_TrackImportBtn;
    QFrame* m_TrackEditFrame;
    QGridLayout* m_gridLayoutTrack;
    QLabel* m_TrackNameLabel;
    QLineEdit* m_TrackNameEdit;
    QLabel* m_TrackSessionLabel;
    QElemList* m_TrackSessionList;
    QSpacerItem* m_TrackEditSpacer;
    void UpdateTrackSessionList();
    void UpdateTrackSessionList(index_t index);
    void setupTracksTab();
    void UpdateTracksUI(index_t newIndex=INDEX_EMPTY);
    std::string elemToString(const Session* s, bool bIncludeID);

    // days
    QHBoxLayout* m_DayGlobalLayout;
    QElemList* m_DayList;
    QSplitter* m_DaySplitter;
    QFrame * m_DayListFrame;
    QGridLayout *m_gridLayoutDayList;
    QPushButton* m_DayImportBtn;
    QFrame* m_DayEditFrame;
    QGridLayout* m_gridLayoutDay;
    QLabel* m_DayNameLabel;
    QDateEdit* m_DayDateEdit;
    QLabel* m_DayTrackLabel;
    QElemList* m_DayTrackList;
    QSpacerItem* m_DayEditSpacer;
    void UpdateDayTrackList();
    void UpdateDayTrackList(index_t index);
    void setupDaysTab();
    void UpdateDaysUI(index_t newIndex=INDEX_EMPTY);
    QString m_strCurrentFile;
    ConferenceDB* m_pConfDB;
    void SetModifyState(bool bModified);
    void SetTitle();

    bool m_bEditBlockSignals;
    bool StartEditBlocker();
    void EndEditBlocker(bool bTemp);

    bool SaveCheck(QString reason);
    void UpdateUI();

    bool saveDB(QString path);

private slots:
    void newDB();
    void cleanup();
    void openDB();
    bool saveDB();
    bool saveDBAs();
    void genDemoDB();
    void quit();

    void conferenceDataChanged();

#ifdef DB_DEPLOY
    bool Compress(const std::vector < std::pair<QFileInfo, QString> >& files,
                  const QString& target);
    void deployDB();
#endif

#ifdef DB_SPECIAL
    void specialImportDB();
#endif

    // general tab
    void generalDataChanged();

    // affiliations
    void affImportCSV();
    void affDataChanged();
    void affNewElement();
    void affDelElement(index_t);
    void affReplaceElement(index_t index);
    void affActiveElement(index_t);

    // people
    void peopleImportCSV();
    void peopleDataChanged();
    void peopleNewElement();
    void peopleDelElement(index_t);
    void peopleReplaceElement(index_t index);
    void peopleActiveElement(index_t);
    void peopleAffNewElement();
    void peopleAffDelElement(index_t index);
    void peoplePermissionMail();
    void peopleRemoveAllButName();

    // Publications
    void publicationsImportCSV();
    void publicationsDataChanged();
    void publicationsNewElement();
    void publicationsDelElement(index_t);
    void publicationsActiveElement(index_t);
    void publicationsAuthorNewElement();
    void publicationsAuthorDelElement(index_t index);
    void publicationsAuthorUpElement(index_t index);
    void publicationsAuthorDownElement(index_t index);

    // Talks
    void talksImportCSV();
    void talksTransferPapers();
    void talksDataChanged();
    void talksNewElement();
    void talksDelElement(index_t);
    void talksActiveElement(index_t);
    void talksSpeakersNewElement();
    void talksSpeakersDelElement(index_t index);
    void talksSpeakersUpElement(index_t index);
    void talksSpeakersDownElement(index_t index);

    // Buildings
    void buidlingImportCSV();
    void buildingShowOnGoogleMaps();
    void buildingsDataChanged();
    void buildingsNewElement();
    void buildingsDelElement(index_t);
    void buildingsActiveElement(index_t);
    void buildingsFloorplansNewElement();
    void buildingsFloorplansDelElement(index_t index);

    // Rooms
    void roomsDataChanged();
    void roomsBuildingCBChanged();
    void roomsFloorCBChanged();
    void roomsNewElement();
    void roomsDelElement(index_t);
    void roomsActiveElement(index_t);

    // Sessions
    void sessionsDataChanged();
    void sessionsActiveElement(index_t index);
    void sessionsNewElement();
    void sessionsDelElement(index_t index);
    void sessionRoomsNewElement();
    void sessionRoomsDelElement(index_t index);
    void sessionTalkListNewElement();
    void sessionTalkListDelElement(index_t index);
    void posterSessionPostersNewElement();
    void posterSessionPostersDelElement(index_t  index);
    void invitedSessionTalksNewElement();
    void invitedSessionTalksDelElement(index_t index);
    void organizedSessionOrganizersNewElement();
    void organizedSessionOrganizersDelElement(index_t index);
    void tutorialSessionTalksNewElement();
    void tutorialSessionTalksDelElement(index_t index);
    void panelSessionPanelistsNewElement();
    void panelSessionPanelistsDelElement(index_t index);

    // Tracks
    void tracksImportCSV();
    void tracksDataChanged();
    void tracksNewElement();
    void tracksDelElement(index_t index);
    void tracksActiveElement(index_t index);
    void tracksSessionNewElement();
    void tracksSessionDelElement(index_t index);

    // Days
    void daysImportCSV();
    void daysDataChanged();
    void daysNewElement();
    void daysDelElement(index_t index);
    void daysActiveElement(index_t index);
    void daysTracksNewElement();
    void daysTracksDelElement(index_t index);

};

#endif // MAINWINDOW_H
