#ifndef QIMPORTDIALOG_H
#define QIMPORTDIALOG_H

#include <QtGui/QDialog>
#include <QtGui/QCheckBox>
#include <QtGui/QFrame>
#include <QtGui/QGridLayout>
#include <QtGui/QGroupBox>
#include <QtGui/QHBoxLayout>
#include <QtGui/QLabel>
#include <QtGui/QListWidget>
#include <QtGui/QPlainTextEdit>
#include <QtGui/QPushButton>
#include <QtGui/QSpacerItem>
#include <QtGui/QSpinBox>

#include <string>
#include <vector>

class QImportDialog : public QDialog
{
    Q_OBJECT

public:
    QImportDialog(const std::vector<std::string>& properties, QWidget *parent = 0);
    ~QImportDialog();

    std::vector<int> GetChoices();
    std::string GetFilename();
    unsigned int GetOffset();
    bool RemoveWhitespaces();

public slots:
    int exec();

private slots:
    void okPressed();
    void cancelPressed();
    void dataChanged();
    void checkInput();

private:
    std::vector<std::string> m_properties;
    void setupUi();

    QString m_filename;

    QVBoxLayout *verticalLayout;
    QGroupBox *groupBox_preview;
    QGridLayout *gridLayout;
    QListWidget *listWidget_preview;
    QPlainTextEdit *plainTextEdit;
    QLabel *label_preview_Input;
    QLabel *label_preview_Output;
    QLabel *label_rowSkip;
    QSpinBox *spinBox_rowSkip;
    QCheckBox *checkBox_remWhitespace;
    QGroupBox *groupBox_setup;
    QGridLayout *gridLayout_setup;
    QLabel* label_property;
    QLabel* label_column;
    std::vector<QCheckBox *> checkBox_setup;
    std::vector<QSpinBox *> spinBox_setup;
    QFrame *frame_btn;
    QHBoxLayout *horizontalLayout;
    QSpacerItem *horizontalSpace_btn;
    QPushButton *pushButton_OK;
    QPushButton *pushButton_Cancel;

};

#endif // QIMPORTDIALOG_H
