#include "mainwindow.h"
#include <QtGui/QMessageBox>
#include <QtGui/QInputDialog>
#include <QtGui/QFileDialog>

#include <QtCore/QTextStream>

#include <algorithm>
#include "QImportDialog.h"
#include "QMailDialog.h"

void MainWindow::setupPeopleTab(){
    m_tabPeople = new QWidget();
    m_tabPeople->setObjectName(QString::fromUtf8("m_tabPeople"));
    m_tabPeople->setWindowTitle(QString::fromUtf8("People"));
    m_globalTabs->addTab(m_tabPeople, m_tabPeople->windowTitle());

    m_PeopleGlobalLayout = new QHBoxLayout(m_tabPeople);
    m_PeopleGlobalLayout->setSpacing(6);
    m_PeopleGlobalLayout->setContentsMargins(0, 0, 0, 0);
    m_PeopleGlobalLayout->setObjectName(QString::fromUtf8("m_PeopleGlobalLayout"));

    m_PeopleSplitter = new QSplitter();
    m_PeopleGlobalLayout->addWidget(m_PeopleSplitter);

    m_PeopleListFrame = new QFrame(m_tabPeople);
    m_PeopleListFrame->setObjectName(QString::fromUtf8("m_PeopleListFrame"));
    m_PeopleListFrame->setFrameShape(QFrame::NoFrame);
    m_PeopleListFrame->setLineWidth(0);
    m_gridLayoutPeopleList = new QGridLayout(m_PeopleListFrame);
    m_gridLayoutPeopleList->setSpacing(6);
    m_gridLayoutPeopleList->setContentsMargins(0, 0, 0, 0);
    m_gridLayoutPeopleList->setObjectName(QString::fromUtf8("m_gridLayoutPeopleList"));

    m_PeopleImportBtn = new QPushButton(m_tabPeople);
    m_PeopleImportBtn->setText("Import People from CSV-File");
    m_gridLayoutPeopleList->addWidget(m_PeopleImportBtn, 0, 0, 1, 1);
    m_PeopleMailBtn = new QPushButton(m_tabPeople);
    m_PeopleMailBtn->setText("Generate permission mails");
    m_gridLayoutPeopleList->addWidget(m_PeopleMailBtn, 0, 1, 1, 1);

    m_PeopleList = new QElemList(m_tabPeople,true);
    m_PeopleList->setObjectName(QString::fromUtf8("m_PeopleList"));
    m_gridLayoutPeopleList->addWidget(m_PeopleList, 1, 0, 1, 2);

    m_PeopleEditFrame = new QFrame(m_tabPeople);
    m_PeopleEditFrame->setObjectName(QString::fromUtf8("m_PeopleEditFrame"));
    m_PeopleEditFrame->setFrameShape(QFrame::NoFrame);
    m_PeopleEditFrame->setFrameShadow(QFrame::Raised);
    m_PeopleEditFrame->setLineWidth(0);
    m_gridLayoutPeople = new QGridLayout(m_PeopleEditFrame);
    m_gridLayoutPeople->setSpacing(6);
    m_gridLayoutPeople->setContentsMargins(0, 0, 0, 0);
    m_gridLayoutPeople->setObjectName(QString::fromUtf8("m_gridLayoutPeople"));

    m_ClearButton = new QPushButton(m_PeopleEditFrame);
    m_ClearButton->setObjectName(QString::fromUtf8("m_ClearToolButton"));
    m_ClearButton->setText(QString::fromUtf8("Remove all but Names"));
    m_gridLayoutPeople->addWidget(m_ClearButton, 0, 0, 1, 2);

    m_PeopleFirstnameLabel = new QLabel(m_PeopleEditFrame);
    m_PeopleFirstnameLabel->setObjectName(QString::fromUtf8("m_PeopleFirstnameLabel"));
    m_PeopleFirstnameLabel->setText(QString::fromUtf8("First Name"));
    m_gridLayoutPeople->addWidget(m_PeopleFirstnameLabel, 1, 0, 1, 1);
    m_PeopleFirstnameEdit = new QLineEdit(m_PeopleEditFrame);
    m_PeopleFirstnameEdit->setObjectName(QString::fromUtf8("m_PeopleFirstnameEdit"));
    m_gridLayoutPeople->addWidget(m_PeopleFirstnameEdit, 1, 1, 1, 1);

    m_PeopleMiddlenameLabel = new QLabel(m_PeopleEditFrame);
    m_PeopleMiddlenameLabel->setObjectName(QString::fromUtf8("m_PeopleMiddlenameLabel"));
    m_PeopleMiddlenameLabel->setText(QString::fromUtf8("Middle Name"));
    m_gridLayoutPeople->addWidget(m_PeopleMiddlenameLabel, 2, 0, 1, 1);
    m_PeopleMiddlenameEdit = new QLineEdit(m_PeopleEditFrame);
    m_PeopleMiddlenameEdit->setObjectName(QString::fromUtf8("m_PeopleMiddlenameEdit"));
    m_gridLayoutPeople->addWidget(m_PeopleMiddlenameEdit, 2, 1, 1, 1);

    m_PeopleLastnameLabel = new QLabel(m_PeopleEditFrame);
    m_PeopleLastnameLabel->setObjectName(QString::fromUtf8("m_PeopleLastnameLabel"));
    m_PeopleLastnameLabel->setText(QString::fromUtf8("Last Name"));
    m_gridLayoutPeople->addWidget(m_PeopleLastnameLabel, 3, 0, 1, 1);
    m_PeopleLastnameEdit = new QLineEdit(m_PeopleEditFrame);
    m_PeopleLastnameEdit->setObjectName(QString::fromUtf8("m_PeopleLastnameEdit"));
    m_gridLayoutPeople->addWidget(m_PeopleLastnameEdit, 3, 1, 1, 1);

    m_PeopleEmailLabel = new QLabel(m_PeopleEditFrame);
    m_PeopleEmailLabel->setObjectName(QString::fromUtf8("m_PeopleEmailLabel"));
    m_PeopleEmailLabel->setText(QString::fromUtf8("Email"));
    m_gridLayoutPeople->addWidget(m_PeopleEmailLabel, 4, 0, 1, 1);
    m_PeopleEmailEdit = new QLineEdit(m_PeopleEditFrame);
    m_PeopleEmailEdit->setObjectName(QString::fromUtf8("m_PeopleEmailEdit"));
    m_gridLayoutPeople->addWidget(m_PeopleEmailEdit, 4, 1, 1, 1);

    m_PeopleTwitterLabel = new QLabel(m_PeopleEditFrame);
    m_PeopleTwitterLabel->setObjectName(QString::fromUtf8("m_PeopleTwitterLabel"));
    m_PeopleTwitterLabel->setText(QString::fromUtf8("Twitter ID"));
    m_gridLayoutPeople->addWidget(m_PeopleTwitterLabel, 5, 0, 1, 1);
    m_PeopleTwitterEdit = new QLineEdit(m_PeopleEditFrame);
    m_PeopleTwitterEdit->setObjectName(QString::fromUtf8("m_PeopleTwitterEdit"));
    m_gridLayoutPeople->addWidget(m_PeopleTwitterEdit, 5, 1, 1, 1);

    m_PeoplePictureURLLabel = new QLabel(m_PeopleEditFrame);
    m_PeoplePictureURLLabel->setObjectName(QString::fromUtf8("m_PeoplePictureURLLabel"));
    m_PeoplePictureURLLabel->setText(QString::fromUtf8("Picture URL"));
    m_gridLayoutPeople->addWidget(m_PeoplePictureURLLabel, 6, 0, 1, 1);
    m_PeoplePictureURLEdit = new QLineEdit(m_PeopleEditFrame);
    m_PeoplePictureURLEdit->setObjectName(QString::fromUtf8("m_PeoplePictureURLEdit"));
    m_gridLayoutPeople->addWidget(m_PeoplePictureURLEdit, 6, 1, 1, 1);

    m_PeopleWebURLLabel = new QLabel(m_PeopleEditFrame);
    m_PeopleWebURLLabel->setObjectName(QString::fromUtf8("m_PeopleWebURLLabel"));
    m_PeopleWebURLLabel->setText(QString::fromUtf8("Webpage URL"));
    m_gridLayoutPeople->addWidget(m_PeopleWebURLLabel, 7, 0, 1, 1);
    m_PeopleWebURLEdit = new QLineEdit(m_PeopleEditFrame);
    m_PeopleWebURLEdit->setObjectName(QString::fromUtf8("m_PeopleWebURLEdit"));
    m_gridLayoutPeople->addWidget(m_PeopleWebURLEdit, 7, 1, 1, 1);

    m_PeopleAffLabel = new QLabel(m_PeopleEditFrame);
    m_PeopleAffLabel->setObjectName(QString::fromUtf8("m_PeopleAffLabel"));
    m_PeopleAffLabel->setText(QString::fromUtf8("Affiliations"));
    m_gridLayoutPeople->addWidget(m_PeopleAffLabel, 8, 0, 1, 2);

    m_PeopleAffList = new QElemList(m_PeopleEditFrame, false, false);
    m_PeopleAffList->setObjectName(QString::fromUtf8("m_PeopleAffList"));
    m_gridLayoutPeople->addWidget(m_PeopleAffList, 9, 0, 1, 2);

    m_PeopleEditSpacer = new QSpacerItem(20, 40, QSizePolicy::Minimum, QSizePolicy::Expanding);
    m_gridLayoutPeople->addItem(m_PeopleEditSpacer, 10, 0, 1, 1);

    m_PeopleSplitter->addWidget(m_PeopleListFrame);
    m_PeopleSplitter->addWidget(m_PeopleEditFrame);

    QObject::connect(m_PeopleFirstnameEdit, SIGNAL(textEdited(QString)), this, SLOT(peopleDataChanged()));
    QObject::connect(m_PeopleFirstnameEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_PeopleMiddlenameEdit, SIGNAL(textEdited(QString)), this, SLOT(peopleDataChanged()));
    QObject::connect(m_PeopleMiddlenameEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_PeopleLastnameEdit, SIGNAL(textEdited(QString)), this, SLOT(peopleDataChanged()));
    QObject::connect(m_PeopleLastnameEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_PeopleEmailEdit, SIGNAL(textEdited(QString)), this, SLOT(peopleDataChanged()));
    QObject::connect(m_PeopleEmailEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_PeopleTwitterEdit, SIGNAL(textEdited(QString)), this, SLOT(peopleDataChanged()));
    QObject::connect(m_PeopleTwitterEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_PeoplePictureURLEdit, SIGNAL(textEdited(QString)), this, SLOT(peopleDataChanged()));
    QObject::connect(m_PeoplePictureURLEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_PeopleWebURLEdit, SIGNAL(textEdited(QString)), this, SLOT(peopleDataChanged()));
    QObject::connect(m_PeopleWebURLEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));

    QObject::connect(m_PeopleList, SIGNAL(newElement()), this, SLOT(peopleNewElement()));
    QObject::connect(m_PeopleList, SIGNAL(newElement()), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_PeopleList, SIGNAL(delElement(index_t)), this, SLOT(peopleDelElement(index_t)));
    QObject::connect(m_PeopleList, SIGNAL(delElement(index_t)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_PeopleList, SIGNAL(activeElement(index_t)), this, SLOT(peopleActiveElement(index_t)));
    QObject::connect(m_PeopleList, SIGNAL(replaceElement(index_t)), this, SLOT(peopleReplaceElement(index_t)));

    QObject::connect(m_PeopleAffList, SIGNAL(newElement()), this, SLOT(peopleAffNewElement()));
    QObject::connect(m_PeopleAffList, SIGNAL(delElement(index_t)), this, SLOT(peopleAffDelElement(index_t)));
    QObject::connect(m_PeopleAffList, SIGNAL(delElement(index_t)), this, SLOT(conferenceDataChanged()));

    QObject::connect(m_PeopleImportBtn, SIGNAL(clicked()), this, SLOT(peopleImportCSV()));
    QObject::connect(m_PeopleMailBtn, SIGNAL(clicked()), this, SLOT(peoplePermissionMail()));

    QObject::connect(m_ClearButton, SIGNAL(clicked()), this, SLOT(peopleRemoveAllButName()));

    peopleActiveElement(INDEX_EMPTY);
}

std::string MainWindow::PersonToString(const SciPerson* p) {
    return p->GetSortableDisplayName(m_pConfDB);
}

void MainWindow::peopleRemoveAllButName() {
    if (m_pConfDB->people.Count() == 0) return;

    QMessageBox::StandardButton reply = QMessageBox::question(this, tr("Clean People Data"),
                                  tr("This will remove all data except the names from the ENTIRE people database. Are you sure you want to proceed?"),
                                    QMessageBox::Yes | QMessageBox::No);
    if (reply == QMessageBox::No) {
        return;
    }

    for (size_t i = 0;i<m_pConfDB->people.Count();i++) {
        SciPerson* s = m_pConfDB->people.GetEntryByPos(i);
        s->SetEmail("");
        s->SetPictureURL("");
        s->GetWebpageURL("");
        s->SetTwitterName("");
    }

    peopleActiveElement(m_PeopleList->GetActiveIndex());
    conferenceDataChanged();
}

void MainWindow::peoplePermissionMail() {
    if (m_pConfDB->people.Count() == 0) return;

    QString shellScript = QFileDialog::getSaveFileName(this,"Name of the shell script", QString::null, "Shell Cripts (*.sh *.command *.bat)");
    if  (shellScript.isEmpty()) return;

    QMailDialog m(this);
    if (QDialog::Accepted != m.exec()) return;

    QFile file(shellScript);
    if(!file.open(QIODevice::WriteOnly | QFile::Truncate )) {
        QMessageBox::information(0, "Unable to open file", file.errorString());
        return;
    }

    QTextStream out(&file);
    out.setCodec("UTF-8");
    for (size_t i = 0;i<m_pConfDB->people.Count();i++) {
        const SciPerson* p = m_pConfDB->people.GetEntryByPos(i);

        // no mail nothing to send
        if (p->GetEmail().empty()) continue;

        out << m.GetMailCommand() << " "
            << m.GetSupplParam() << " "
            << m.GetFromParam() << " \"" << QString::fromUtf8(m_pConfDB->GetContactMail().c_str()) << "\" "
            << m.GetSubjectParam() << " \"" << QString::fromUtf8(m_pConfDB->GetTitle().c_str()) << "\" "
            << m.GetToParam() << " \"" << QString::fromUtf8(p->GetEmail().c_str()) << "\" "
            << m.GetBodyParam() << " \"Dear " << QString::fromUtf8(p->GetDisplayName().c_str()) << "!\n\n"
            << "For the " << QString::fromUtf8(m_pConfDB->GetTitle().c_str()) << " conference we providing "
            << "the conference schedule together with a database of all accepted publications and their authors in the "
            << "Conference Manager app (see http://www.ivda.uni-saarland.de/software/releases/confman.html). "
            << "In addition to the names and affiliation we can include additional information about each author. "
            << "Therefore, we ask for your help in gathering this data. In the list below you can fill out all the "
            << "data you would like us to include in the app or remove entries you don't want us to include. "
            << "Please note: If we don't hear back from you at all, we assume that you want no additional "
            << "information other than your name and affiliation in the app. So even if the entries below "
            << "are complete and correct, please still reply to this mail so we know that we have your permission.\n\n"

            << "   Your Email:" << QString::fromUtf8(p->GetEmail().c_str()) << "\n"
            << "   Your Webpage:" << QString::fromUtf8(p->GetWebpageURL().c_str()) << "\n"
            << "   URL of picture of yourself:" << QString::fromUtf8(p->GetPictureURL().c_str()) << "\n"
            << "   Twitter ID:" << QString::fromUtf8(p->GetTwitterName().c_str()) << "\n\n"

            << "Thank you very much for your help\n"
            << "  The organizers of " << QString::fromUtf8(m_pConfDB->GetTitle().c_str()) << "\"\n";
    }
    file.close();
}

void MainWindow::peopleImportCSV() {
    if (!SaveCheck("importing people from CSV file")) return;

    std::vector<std::string> properties;
    properties.push_back("First Name");
    properties.push_back("Middle Name");
    properties.push_back("Last Name");
    properties.push_back("Email");
    properties.push_back("Twitter ID");
    properties.push_back("Picture URL");
    properties.push_back("Webpage URL");

    QImportDialog d(properties, this);
    if (QDialog::Accepted != d.exec()) return;

    std::string filename = d.GetFilename();
    if (!filename.empty()) {
        std::vector<int> choices = d.GetChoices();
        CSFParser csvData(filename,d.GetOffset(), d.RemoveWhitespaces());
        csvData.SetRecordSizeToMax();

        for (size_t i = 0;i<csvData.RecordCount();i++) {
            std::vector< std::string > csvRecord = csvData.GetRecord(i);
            SciPerson p(choices[0]>= 0 ? csvRecord[choices[0]] : "",
                        choices[1]>= 0 ? csvRecord[choices[1]] : "",
                        choices[2]>= 0 ? csvRecord[choices[2]] : "",
                        choices[3]>= 0 ? csvRecord[choices[3]] : "",
                        choices[4]>= 0 ? csvRecord[choices[4]] : "",
                        choices[5]>= 0 ? csvRecord[choices[5]] : "",
                        choices[6]>= 0 ? csvRecord[choices[6]] : "");
            m_pConfDB->people.AddUniqueEntry(p);
        }

        conferenceDataChanged();
        UpdateUI();
    }
}

void MainWindow::UpdatePeopleUI(index_t newIndex) {
    std::vector< ElemListEntry > peopleList;
    for (size_t i = 0;i<m_pConfDB->people.Count();++i) {
        peopleList.push_back( ElemListEntry(PersonToString(m_pConfDB->people.GetEntryByPos(i)),
                                            m_pConfDB->people.GetEntryByPos(i)->GetIndex(),
                                            m_pConfDB->people.GetEntryByPos(i)->GetReferenceCount(m_pConfDB))  );
    }
    m_PeopleList->ElemUpdate(peopleList, newIndex);
    UpdatePeopleAffList();
}

void MainWindow::UpdatePeopleAffList() {
    bool b = StartEditBlocker();
    UpdatePeopleAffList(m_PeopleList->GetActiveIndex());
    EndEditBlocker(b);
}

void MainWindow::UpdatePeopleAffList(index_t index) {
    const SciPerson* s = m_pConfDB->people.GetEntryByIndex(index);

    std::vector< ElemListEntry > affList;
    if (s) {
        for (size_t i = 0;i<s->GetAffiliations().size();++i) {
            index_t affIndex = s->GetAffiliations()[i];
            const Affiliation* aff = m_pConfDB->affiliations.GetEntryByIndex(affIndex);
            affList.push_back( ElemListEntry(aff->GetName() + std::string(" - ") + aff->GetAddress(),
                                             aff->GetIndex()));
        }
    }
    m_PeopleAffList->ElemUpdate(affList, index);
}

// Slots


void MainWindow::peopleDataChanged(){
    index_t index = m_PeopleList->GetActiveIndex();
    SciPerson* s = m_pConfDB->people.GetEntryByIndex(index);

    s->SetFirstName(std::string(m_PeopleFirstnameEdit->text().toUtf8()));
    s->SetMiddleName(std::string(m_PeopleMiddlenameEdit->text().toUtf8()));
    s->SetLastName(std::string(m_PeopleLastnameEdit->text().toUtf8()));
    s->SetEmail(std::string(m_PeopleEmailEdit->text().toUtf8()));
    s->SetPictureURL(std::string(m_PeoplePictureURLEdit->text().toUtf8()));
    s->GetWebpageURL(std::string(m_PeopleWebURLEdit->text().toUtf8()));
    s->SetTwitterName(std::string(m_PeopleTwitterEdit->text().toUtf8()));

    UpdatePeopleUI(index);
    UpdatePublicationUIEdits();
    UpdateSessionsUI();
    UpdateTalksUIEdits();
    SessionsFillChairCB();
}

void MainWindow::peopleNewElement() {
    SciPerson newPers("","", "New", "", "", "", "");
    index_t index = m_pConfDB->people.AddEntry(newPers);
    UpdatePeopleUI(index);
    SessionsFillChairCB();
}

void MainWindow::peopleDelElement(index_t index){
    const SciPerson* p =  m_pConfDB->people.GetEntryByIndex(index);
    assert(p);
    assert(p->GetReferenceCount(m_pConfDB) == 0);

    m_pConfDB->people.RemoveEntryByIndex(index);
    UpdatePeopleUI(INDEX_EMPTY);
    UpdateAffUI();
    SessionsFillChairCB();
}

void MainWindow::peopleReplaceElement(index_t index){
    const SciPerson* p =  m_pConfDB->people.GetEntryByIndex(index);
    assert(p);

    QStringList items;
    for (size_t i = 0;i<m_pConfDB->people.Count();++i) {
        const SciPerson* pers = m_pConfDB->people.GetEntryByPos(i);

        if (pers->GetIndex() != p->GetIndex())
            items << QString::fromUtf8(PersonToString(pers).c_str());
    }

    if (items.count() == 0) {
        QMessageBox msgBox;
        msgBox.setIcon(QMessageBox::Warning);
        msgBox.setText("No additional rooms available.");
        msgBox.exec();
        return;
    }

    items.sort();

    bool ok;
    QString item = QInputDialog::getItem(this, tr("Select replacement Person"),
                                         tr("Available Person:"),
                                         items, 0, false, &ok);
    if (ok && !item.isEmpty()) {
        for (size_t i = 0;i<m_pConfDB->people.Count();++i) {
            const SciPerson* pers = m_pConfDB->people.GetEntryByPos(i);

            if (item == QString::fromUtf8(PersonToString(pers).c_str())) {
                m_pConfDB->people.ReplaceIndexByEntry(index, *pers, m_pConfDB);
                UpdatePeopleUI(index);
                UpdatePublicationUIEdits();
                UpdateSessionsUI();
                UpdateTalksUIEdits();
                SessionsFillChairCB();
                break;
            }
        }

    }
}

void MainWindow::peopleAffNewElement() {
    QStringList items;
    index_t personIndex = m_PeopleList->GetActiveIndex();
    SciPerson* s = m_pConfDB->people.GetEntryByIndex(personIndex);
    assert(s);

    for (size_t i = 0;i<m_pConfDB->affiliations.Count();++i) {
        const Affiliation* aff = m_pConfDB->affiliations.GetEntryByPos(i);
        if (std::find(s->GetAffiliations().begin(), s->GetAffiliations().end(), aff->GetIndex()) == s->GetAffiliations().end())
            items << QString::fromUtf8((aff->GetName() + std::string(" - ") + aff->GetAddress()).c_str());
    }

    if (items.count() == 0) {
        QMessageBox msgBox;
        msgBox.setIcon(QMessageBox::Warning);
        msgBox.setText("No additional affiliations available.");
        msgBox.exec();
        return;
    }

    items.sort();

    bool ok;
    QString item = QInputDialog::getItem(this, tr("Select Additional Affiliation"),
                                         tr("Affiliation:"), items, 0, false, &ok);
    if (ok && !item.isEmpty()) {
        for (size_t i = 0;i<m_pConfDB->affiliations.Count();++i) {
            const Affiliation* aff = m_pConfDB->affiliations.GetEntryByPos(i);
            if (item == QString::fromUtf8((aff->GetName() + std::string(" - ") + aff->GetAddress()).c_str())) {
                s->AddAffiliation(*aff);
                break;
            }
        }

        UpdatePeopleUI(personIndex);
        UpdatePublicationUIEdits();
        UpdateSessionsUI();
        UpdateTalksUIEdits();
        SessionsFillChairCB();
        UpdateAffUI();
        conferenceDataChanged();
    }
}

void MainWindow::peopleAffDelElement(index_t index) {
    index_t personIndex = m_PeopleList->GetActiveIndex();
    SciPerson* s = m_pConfDB->people.GetEntryByIndex(personIndex);
    s->DelAffiliation(index);

    UpdatePeopleUI(personIndex);
    UpdatePublicationUIEdits();
    UpdateSessionsUI();
    UpdateTalksUIEdits();
    UpdateAffUI();
    SessionsFillChairCB();
}

void MainWindow::peopleActiveElement(index_t index){
    const SciPerson* s = m_pConfDB->people.GetEntryByIndex(index);
    if (s) {
        m_PeopleFirstnameEdit->setText(QString::fromUtf8(s->GetFirstName().c_str()));
        m_PeopleMiddlenameEdit->setText(QString::fromUtf8(s->GetMiddleName().c_str()));
        m_PeopleLastnameEdit->setText(QString::fromUtf8(s->GetLastName().c_str()));
        m_PeopleEmailEdit->setText(QString::fromUtf8(s->GetEmail().c_str()));
        m_PeoplePictureURLEdit->setText(QString::fromUtf8(s->GetPictureURL().c_str()));
        m_PeopleWebURLEdit->setText(QString::fromUtf8(s->GetWebpageURL().c_str()));
        m_PeopleTwitterEdit->setText(QString::fromUtf8(s->GetTwitterName().c_str()));

        UpdatePeopleAffList(index);

        m_PeopleFirstnameEdit->setEnabled(true);
        m_PeopleMiddlenameEdit->setEnabled(true);
        m_PeopleLastnameEdit->setEnabled(true);
        m_PeopleEmailEdit->setEnabled(true);
        m_PeoplePictureURLEdit->setEnabled(true);
        m_PeopleWebURLEdit->setEnabled(true);
        m_PeopleTwitterEdit->setEnabled(true);
        m_PeopleAffList->setEnabled(true);
    } else {
        m_PeopleFirstnameEdit->setText("");
        m_PeopleMiddlenameEdit->setText("");
        m_PeopleLastnameEdit->setText("");
        m_PeopleEmailEdit->setText("");
        m_PeoplePictureURLEdit->setText("");
        m_PeopleWebURLEdit->setText("");
        m_PeopleTwitterEdit->setText("");
        m_PeopleAffList->Clear();
        m_PeopleFirstnameEdit->setEnabled(false);
        m_PeopleMiddlenameEdit->setEnabled(false);
        m_PeopleLastnameEdit->setEnabled(false);
        m_PeopleEmailEdit->setEnabled(false);
        m_PeoplePictureURLEdit->setEnabled(false);
        m_PeopleWebURLEdit->setEnabled(false);
        m_PeopleTwitterEdit->setEnabled(false);
        m_PeopleAffList->setEnabled(false);
    }
}
