#ifndef WORKDAY_H
#define WORKDAY_H

#include "Track.h"
#include "StringList.h"

class ConferenceDB;

class WorkDay : public Indexable {
public:
  WorkDay(const unsigned int iDay,
          const unsigned int iMonth,
          const int iYear);
  
  WorkDay(const unsigned int iDay,
          const unsigned int iMonth,
          const int iYear,
          const std::vector<index_t>& vTracks);
  
  WorkDay(std::istream& stream);
  
  int GetDay() const {return m_iDay;}
  int GetMonth() const {return m_iMonth;}
  int GetYear() const {return m_iYear;}
  const std::vector<index_t>& GetTracks() const {return m_vTracks;}
  
  void SetDay(unsigned int d) {m_iDay = d;}
  void SetMonth(unsigned int m) {m_iMonth = m;}
  void SetYear(int y) {m_iYear = y;}
  void SetTracks(const std::vector<index_t>& vTracks)  {m_vTracks = vTracks;}
  void AddTrack(const Track& Track)  {m_vTracks.push_back(Track.GetIndex());}
  void DelTrack(index_t index);
  unsigned int ReplaceTrack(const Track& track, const Track& newTrack);

  void GetStatistics(unsigned int& tracks, unsigned int& sessions, const ConferenceDB* pDB) const;
  
  static std::string GetClassName() {return "WorkDay";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  
  virtual bool Validate(const ConferenceDB* confDB) const;
  virtual unsigned int GetReferenceCount(const ConferenceDB* confDB) const;

  bool operator==(const WorkDay &other) const {
    return other.m_iDay == m_iDay &&
           other.m_iMonth == m_iMonth &&
           other.m_iYear == m_iYear &&
           other.m_vTracks == m_vTracks;
  }

protected:
  WorkDay() : Indexable() {}
  
  unsigned int m_iDay;
  unsigned int m_iMonth;
  int m_iYear;  
  std::vector<index_t> m_vTracks;  
  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};


#endif // WORKDAY_H
