#ifndef TUTORIAL_H
#define TUTORIAL_H

#include "OrganizedSession.h"
#include "InvitedTalk.h"
#include "StringList.h"


class Tutorial : public OrganizedSession {
public:
    Tutorial(const std::string& strTitle,
             const int iStartTime,
             const int iEndTime,
             const std::string& strAbstract);
    
    Tutorial(const std::string& strTitle,
             const int iStartTime,
             const int iEndTime,
             const SciPerson& sessionChair,
             const bool bChairAcceptsMail, 
             const std::string& strAbstract);  
    
    Tutorial(const std::string& strTitle, 
             const int iStartTime,
             const int iEndTime,
             const SciPerson& sessionChair,
             const bool bChairAcceptsMail, 
             const std::string& strAbstract, 
             const std::vector<index_t>& vOrganizers,
             const std::vector<index_t>& vLocations,
             const std::vector<index_t>& vTutorialTalks);  
    
    Tutorial(std::istream& stream);
    
    virtual bool Validate(const ConferenceDB* confDB) const;
    bool Contains(const Talk* t) const;  
    
    virtual std::string GetSessionType() const {return StringList::strTutorial;}        
    static std::string GetClassName() {return "Tutorial";} 
    virtual std::string GetClassNameViaObject() const {return GetClassName();} 
    
    const std::vector<index_t>& GetTutorialTalks() const {return m_vTutorialTalks;}
    void SetTutorialTalks(const std::vector<index_t>& vTutorialTalks)  {m_vTutorialTalks = vTutorialTalks;}
    void AddTutorialTalk(const InvitedTalk& tutorialTalk)  {m_vTutorialTalks.push_back(tutorialTalk.GetIndex());}
    void DelTutorialTalk(index_t index);
    
    bool operator==(const Tutorial &other) const {
      return other.m_vTutorialTalks == m_vTutorialTalks &&
             OrganizedSession::operator==(other);
    }

protected:
    Tutorial() : OrganizedSession() {}
    
    std::vector<index_t> m_vTutorialTalks;  
    
    virtual void SerializeValues(std::string& serializationString) const;
    virtual bool DeserializeValues(std::istream& stream);  
};


#endif // TUTORIAL_H
