#ifndef TALK_H
#define TALK_H

#include <string>
#include "Serializable.h"
#include "Indexable.h"
#include "SciPerson.h"

class Session;
class ConferenceDB;

class Talk : public Indexable {
public:
  Talk(const std::string& strTitle, 
       const int iStartTime,
       const int iEndTime);
  
  Talk(const std::string& strTitle, 
       const std::vector<index_t>& vSpeakers,
       const int iStartTime,
       const int iEndTime);
  
  Talk(std::istream& stream);
    
  const std::string& GetTitle() const {return m_strTitle;}
  const std::vector<index_t>& GetSpeakers() const {return m_vSpeakers;}
  
  void SetTitle(const std::string& strTitle)  {m_strTitle = strTitle;}
  void SetSpeakers(const std::vector<index_t>& vSpeakers)  {m_vSpeakers = vSpeakers;}
  void AddSpeaker(const SciPerson& speaker)  {m_vSpeakers.push_back(speaker.GetIndex());}
  void DelSpeaker(const index_t speakerIndex);
  void SpeakerUp(const index_t speakerIndex);
  void SpeakerDown(const index_t speakerIndex);

  unsigned int ReplaceSpeaker(const SciPerson& person, const SciPerson& newPerson);

  int GetStartTime() const {return m_iStartTime;}
  void SetStartTime(const int iStartTime) {m_iStartTime = iStartTime;}
  int GetEndTime() const {return m_iEndTime;}
  void SetEndTime(const int iEndTime) {m_iEndTime = iEndTime;}
  
  std::string GetDisplaySpeakers(const ConferenceDB* confDB) const;
  const Session* FindContainingSession(const ConferenceDB* confDB) const;
    
  virtual std::string GetTalkType() {return "Talk";}
  
  static std::string GetClassName() {return "Talk";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  virtual bool Validate(const ConferenceDB* confDB) const;
  unsigned int GetReferenceCount(const ConferenceDB* confDB) const;
  
  bool operator==(const Talk &other) const {
    return other.m_strTitle == m_strTitle &&
           other.m_vSpeakers == m_vSpeakers &&
           other.m_iStartTime == m_iStartTime &&
           other.m_iEndTime == m_iEndTime;
  }

protected:
  Talk() : Indexable() {}
  std::string m_strTitle;
  std::vector<index_t> m_vSpeakers;  
  int m_iStartTime;
  int m_iEndTime;
  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};


#endif // TALK_H
