#ifndef SCIPERSON_H
#define SCIPERSON_H

#include "Affiliation.h"

class ConferenceDB;

class SciPerson : public Indexable {
public:
  SciPerson(const std::string& strFirstName, 
            const std::string& strMiddleName,
            const std::string& strLastName,
            const std::string& strEmail,
            const std::string& strTwitterName,
            const std::string& strPictureURL,
            const std::string& strWebpageURL);
  
  SciPerson(const std::string& strFirstName, 
            const std::string& strMiddleName,
            const std::string& strLastName,
            const std::string& strEmail,
            const std::string& strTwitterName,
            const std::string& strPictureURL,
            const std::string& strWebpageURL,
            const std::vector<index_t>& vAffiliations);
  
  SciPerson(std::istream& stream);
    
  const std::string& GetFirstName() const {return m_strFirstName;}
  const std::string& GetMiddleName() const {return m_strMiddleName;}
  const std::string& GetLastName() const {return m_strLastName;}
  const std::string& GetEmail() const {return m_strEmail;}
  const std::string& GetPictureURL() const {return m_strPictureURL;}
  const std::string& GetWebpageURL() const {return m_strWebpageURL;}
  const std::vector<index_t>& GetAffiliations() const {return m_vAffiliations;}
  const std::string& GetTwitterName() const {return m_strTwitterName;}

  void SetTwitterName(const std::string& strTwitterName) {m_strTwitterName = strTwitterName;}
  void SetFirstName(const std::string& strFirstName)  {m_strFirstName = strFirstName;}
  void SetMiddleName(const std::string& strMiddleName)  {m_strMiddleName = strMiddleName;}
  void SetLastName(const std::string& strLastName)  {m_strLastName = strLastName;}
  void SetEmail(const std::string& strEmail)  {m_strEmail = strEmail;}
  void SetPictureURL(const std::string& strPictureURL) {m_strPictureURL = strPictureURL;}
  void GetWebpageURL(const std::string& strWebpageURL) {m_strWebpageURL = strWebpageURL;}
  void SetAffiliations(const std::vector<index_t>& vAffiliations)  {m_vAffiliations = vAffiliations;}
  void AddAffiliation(const Affiliation& affiliation)  {m_vAffiliations.push_back(affiliation.GetIndex());}
  void DelAffiliation(index_t index);
  unsigned int ReplaceAffiliation(const Affiliation& aff, const Affiliation& newAff);

  std::string GetDisplayName() const;
  std::string GetSortableDisplayName(const ConferenceDB* db) const;
  std::string GetDisplayAffiliations(const ConferenceDB* db) const;

  std::vector<index_t> GetWorksAtThisConference(const ConferenceDB* db) const;
  
  static std::string GetClassName() {return "SciPerson";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  
  virtual bool Validate(const ConferenceDB* confDB) const;
  unsigned int GetReferenceCount(const ConferenceDB* confDB) const;
  unsigned int Replace(const SciPerson& newPers, ConferenceDB* confDB) const;

  bool operator==(const SciPerson &other) const {
    return other.m_strFirstName == m_strFirstName &&
           other.m_strMiddleName == m_strMiddleName &&
           other.m_strLastName == m_strLastName &&
           other.m_strEmail == m_strEmail &&
           other.m_strTwitterName == m_strTwitterName &&
           other.m_strPictureURL == m_strPictureURL &&
           other.m_strWebpageURL == m_strWebpageURL &&
           other.m_vAffiliations == m_vAffiliations;
  }

protected:
  SciPerson() : Indexable() {}
  
  std::string m_strFirstName;
  std::string m_strMiddleName;
  std::string m_strLastName;
  std::string m_strEmail;
  std::string m_strTwitterName;
  std::string m_strPictureURL;
  std::string m_strWebpageURL;
  std::vector<index_t> m_vAffiliations;  

  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};


#endif // SCIPERSON_H
