#ifndef ROOM_H
#define ROOM_H

#include <string>
#include "Serializable.h"
#include "Indexable.h"
#include "Building.h"

class ConferenceDB;

class Room : public Indexable {
public:
  Room(const std::string& strName,
       const size_t iFloorIndex,
       const Building& building,
       float fMapX,
       float fMapY);
  
  Room(std::istream& stream);
  
  const std::string& GetName() const {return m_strName;}
  void SetName(const std::string& strName)  {m_strName = strName;}

  index_t GetBuilding() const {return m_iBuilding;}
  void SetBuilding(const Building& building)  {m_iBuilding = building.GetIndex();}
  
  size_t GetFloorIndex() const {return m_iFloorIndex;}
  void SetFloorIndex(const int iFloorIndex)  {m_iFloorIndex = iFloorIndex;}

  void GetMapPosition(float& fMapX, float& fMapY) const;
  void SetMapPosition(float fMapX, float fMapY);
  
  static std::string GetClassName() {return "Room";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  
  std::string GetDisplayName(const ConferenceDB* db) const;
  virtual bool Validate(const ConferenceDB* confDB) const;
  unsigned int GetReferenceCount(const ConferenceDB* confDB) const;
  
  bool operator==(const Room &other) const {
    return other.m_strName == m_strName &&
           other.m_iFloorIndex == m_iFloorIndex &&
           other.m_iBuilding == m_iBuilding &&
           other.m_fMapX == m_fMapX &&
           other.m_fMapY == m_fMapY;
  }

protected:
  Room() : Indexable() {}
  std::string m_strName;
  size_t m_iFloorIndex;
  index_t m_iBuilding;  

  float m_fMapX;
  float m_fMapY;
  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};


#endif // ROOM_H
