#include "Room.h"
#include "ConferenceDB.h"

#include <algorithm>

Room::Room(const std::string& strName,
           const size_t iFloorIndex,
           const Building& building,
           float fMapX,
           float fMapY) :
Indexable(),
m_strName(strName),
m_iFloorIndex(iFloorIndex),
m_iBuilding(building.GetIndex()),
m_fMapX(fMapX),
m_fMapY(fMapY)
{
}

Room::Room(std::istream& stream) :
Indexable()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void Room::SerializeValues(std::string& serializationString) const {
  Indexable::SerializeValues(serializationString);
  AddSerialization(serializationString, m_strName);
  AddSerialization(serializationString, m_iFloorIndex);
  AddSerialization(serializationString, m_iBuilding);
  AddSerialization(serializationString, m_fMapX);
  AddSerialization(serializationString, m_fMapY);
}

bool Room::DeserializeValues(std::istream& stream) {
  if (!Indexable::DeserializeValues(stream)) return false;  
  if (!DeserializeValue(stream, m_strName)) return false;
  if (!DeserializeValue(stream, m_iFloorIndex)) return false;
  if (!DeserializeValue(stream, m_iBuilding)) return false;
  if (!DeserializeValue(stream, m_fMapX)) return false;
  return DeserializeValue(stream, m_fMapY);
}

void Room::GetMapPosition(float& fMapX, float& fMapY) const {
  fMapX = m_fMapX;
  fMapY = m_fMapY;
}

void Room::SetMapPosition(float fMapX, float fMapY) {
  m_fMapX = fMapX;
  m_fMapY = fMapY;
}

std::string Room::GetDisplayName(const ConferenceDB* db) const {
  const Building* b = db->buildings.GetEntryByIndex(m_iBuilding);  
  if (!b) return m_strName;
  
  std::stringstream ss;  
  if ( b->GetFloorplans().size() <= m_iFloorIndex) {
    ss << m_strName.c_str() << ", " << b->GetName().c_str();
  } else {
      ss << m_strName.c_str() << ", " << b->GetName().c_str() << ", " << b->GetFloorplans()[m_iFloorIndex].m_desc.c_str();
  }
  
  return ss.str();
}

bool Room::Validate(const ConferenceDB* confDB) const {
  const Building* b = confDB->buildings.GetEntryByIndex(m_iBuilding);
  if (!b) return false;
  if (b->GetFloorplans().size() <= m_iFloorIndex) return false;  
  return true;
}

unsigned int Room::GetReferenceCount(const ConferenceDB* confDB) const {
  unsigned int refs = 0;
  for (size_t i = 0;i<confDB->sessions.Count();++i) {
    const Session* potentialSession = confDB->sessions.GetEntryByPos(i);    
    const std::vector<index_t>& roomes = potentialSession->GetRooms();
    if (std::find(roomes.begin(), roomes.end(), m_iIndex) != roomes.end() ) {
      refs++;
    }
  }
  return refs;
}
