#ifndef POSTERSESSION_H
#define POSTERSESSION_H

#include "Session.h"
#include "Poster.h"
#include "StringList.h"

class ConferenceDB;

class PosterSession : public Session {
public:
  PosterSession(const std::string& strTitle, 
                const int iStartTime,
                const int iEndTime);

  PosterSession(const std::string& strTitle, 
               const int iStartTime,
               const int iEndTime,
               const SciPerson& sessionChair,
               const bool bChairAcceptsMail);
  
  PosterSession(const std::string& strTitle, 
               const int iStartTime,
               const int iEndTime,
               const SciPerson& sessionChair,
               const bool bChairAcceptsMail, 
               const std::vector<index_t>& vLocations,
               const std::vector<index_t>& vPosters);
  
  PosterSession(std::istream& stream);
  
  const std::vector<index_t>& GetPosters() const {return m_vPosters;}
  void SetPosters(const std::vector<index_t>& vPosters)  {m_vPosters = vPosters;}
  void AddPoster(const Poster& poster)  {m_vPosters.push_back(poster.GetIndex());}
  void DelPoster(index_t index);
  
  virtual std::string GetSessionType() const {return StringList::strPosterSession;}

  static std::string GetClassName() {return "PosterSession";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  
  virtual bool Contains(const Poster* p) const;
  virtual bool Validate(const ConferenceDB* confDB) const;
  
  bool operator==(const PosterSession &other) const {
    return other.m_vPosters == m_vPosters &&
           Session::operator==(other);
  }

protected:
  PosterSession() : Session() {}
  
  std::vector<index_t> m_vPosters;
  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};


#endif // POSTERSESSION_H
