#include <algorithm>

#include "PosterSession.h"
#include "ConferenceDB.h"

PosterSession::PosterSession(const std::string& strTitle, 
                             const int iStartTime,
                             const int iEndTime) :
Session(strTitle, iStartTime, iEndTime, GetClassName())
{
}

PosterSession::PosterSession(const std::string& strTitle, 
                           const int iStartTime,
                           const int iEndTime,
                           const SciPerson& sessionChair,
                           const bool bChairAcceptsMail) :
Session(strTitle,iStartTime,iEndTime,sessionChair,bChairAcceptsMail,GetClassName())
{
}

PosterSession::PosterSession(const std::string& strTitle, 
                           const int iStartTime,
                           const int iEndTime,
                           const SciPerson& sessionChair,
                           const bool bChairAcceptsMail, 
                           const std::vector<index_t>& vLocations,
                           const std::vector<index_t>& vPosters) :
Session(strTitle,iStartTime,iEndTime,sessionChair,bChairAcceptsMail,GetClassName(),vLocations),
m_vPosters(vPosters)
{
}

PosterSession::PosterSession(std::istream& stream) :
Session()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void PosterSession::SerializeValues(std::string& serializationString) const {
  Session::SerializeValues(serializationString);
  AddVectorSerialization(serializationString, m_vPosters);
}

bool PosterSession::DeserializeValues(std::istream& stream) {
  if (!Session::DeserializeValues(stream)) return false;
  return DeserializeVector(stream, m_vPosters);
}

void PosterSession::DelPoster(index_t index) {
    for (size_t i = 0;i<m_vPosters.size();++i) {
      if (m_vPosters[i] == index)
        m_vPosters.erase(m_vPosters.begin()+i);
    }
}

bool PosterSession::Contains(const Poster* p) const {
  index_t index = p->GetIndex();
  if (std::find(m_vPosters.begin(), m_vPosters.end(), index) != m_vPosters.end() ) {
    return true;
  }
  return false;
}

bool PosterSession::Validate(const ConferenceDB* confDB) const {
  if (!Session::Validate(confDB)) return false;
  
  for (size_t i = 0;i<m_vPosters.size();++i) {
    const SciWork* p = confDB->works.GetEntryByIndex(m_vPosters[i]);
    if (!p || !dynamic_cast<const Poster*>(p)) return false;
  }  
  return true;
}
