#include "Poster.h"
#include "ConferenceDB.h"
#include "PosterSession.h"

Poster::Poster(const std::string& strTitle, 
               const std::string& strAbstract, 
               const std::string& strURL, 
               const std::string& strPreviewURL, 
               const std::string& strPDFURL) :
SciWork(strTitle,strAbstract,strURL,strPreviewURL,strPDFURL)
{
}

Poster::Poster(const std::string& strTitle, 
               const std::string& strAbstract, 
               const std::string& strURL, 
               const std::string& strPreviewURL, 
               const std::string& strPDFURL, 
               const std::vector<index_t>& vAuthors) :
SciWork(strTitle,strAbstract,strURL,strPreviewURL,strPDFURL,vAuthors)
{
}

Poster::Poster(std::istream& stream) :
SciWork()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void Poster::SerializeValues(std::string& serializationString) const {
  SciWork::SerializeValues(serializationString);
}

bool Poster::DeserializeValues(std::istream& stream) {
  if (!SciWork::DeserializeValues(stream)) return false;
  return true;
}

const PosterSession* Poster::FindContainingSession(const ConferenceDB* confDB) const {
  for (size_t i = 0;i<confDB->sessions.Count();++i) {
    const Session* s = confDB->sessions.GetEntryByPos(i);
    const PosterSession* ps = dynamic_cast<const PosterSession*>(s);
    if (!ps) continue;
    
    for (size_t j = 0;j<ps->GetPosters().size();++j) {
      if (ps->GetPosters()[j] == m_iIndex) {
        return ps;
      }
    }
  }
  return NULL;  
}

unsigned int Poster::GetReferenceCount(const ConferenceDB* confDB) const {
  unsigned int refs = 0;
  for (size_t i = 0;i<confDB->sessions.Count();++i) {
    const PosterSession* ps = dynamic_cast<const PosterSession*>(confDB->sessions.GetEntryByPos(i));
    if (!ps) continue;
    
    for (size_t j = 0;j<ps->GetPosters().size();++j) {
      if (ps->GetPosters()[j] == m_iIndex) {
        refs++;
      }
    }
  }
  return refs;
}
