#ifndef PAPERSESSION_H
#define PAPERSESSION_H

#include "Session.h"
#include "PaperTalk.h"
#include "StringList.h"

class ConferenceDB;

class PaperSession : public Session {
public:
    PaperSession(const std::string& strTitle,
                 const int iStartTime,
                 const int iEndTime);

    PaperSession(const std::string& strTitle,
               const int iStartTime,
               const int iEndTime,
               const SciPerson& sessionChair,
               const bool bChairAcceptsMail);
  
  PaperSession(const std::string& strTitle, 
               const int iStartTime,
               const int iEndTime,
               const SciPerson& sessionChair,
               const bool bChairAcceptsMail, 
               const std::vector<index_t>& vLocations,
               const std::vector<index_t>& vPaperTalks);
  
  PaperSession(std::istream& stream);
  
  const std::vector<index_t>& GetPaperTalks() const {return m_vPaperTalks;}
  void SetPaperTalks(const std::vector<index_t>& vPaperTalks)  {m_vPaperTalks = vPaperTalks;}
  void AddPaperTalk(const PaperTalk& PaperTalk)  {m_vPaperTalks.push_back(PaperTalk.GetIndex());}
  void DelPaperTalk(index_t index);

  virtual std::string GetSessionType() const {return StringList::strPaperTalks;}

  static std::string GetClassName() {return "PaperSession";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  
  virtual bool Contains(const Talk* t) const;
  virtual bool Validate(const ConferenceDB* confDB) const;
  
  bool operator==(const PaperSession &other) const {
    return other.m_vPaperTalks == m_vPaperTalks &&
           Session::operator==(other);
  }

protected:
  PaperSession() : Session() {}
  
  std::vector<index_t> m_vPaperTalks;  
  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};


#endif // PAPERSESSION_H
