#include "Paper.h"
#include "PaperTalk.h"
#include "ConferenceDB.h"

Paper::Paper(const std::string& strTitle, 
             const std::string& strAbstract, 
             const std::string& strURL, 
             const std::string& strPreviewURL, 
             const std::string& strPDFURL) :
SciWork(strTitle,strAbstract,strURL,strPreviewURL,strPDFURL)
{
}

Paper::Paper(const std::string& strTitle, 
             const std::string& strAbstract, 
             const std::string& strURL, 
             const std::string& strPreviewURL, 
             const std::string& strPDFURL, 
             const std::vector<index_t>& vAuthors) :
SciWork(strTitle,strAbstract,strURL,strPreviewURL,strPDFURL,vAuthors)
{
}

Paper::Paper(std::istream& stream) :
SciWork()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void Paper::SerializeValues(std::string& serializationString) const {
  SciWork::SerializeValues(serializationString);

}

bool Paper::DeserializeValues(std::istream& stream) {
  if (!SciWork::DeserializeValues(stream)) return false;  
  return true;
}

const PaperTalk* Paper::FindContainingTalk(const ConferenceDB* confDB) const {
  for (size_t i = 0;i<confDB->talks.Count();++i) {
    const Talk* t = confDB->talks.GetEntryByPos(i);
    const PaperTalk* pt = dynamic_cast<const PaperTalk*>(t);
    if (!pt) continue;
    
    if (pt->GetPaper() == m_iIndex) {
      return pt;
    }
  }
  return NULL;
}

unsigned int Paper::Replace(const Paper& newPaper, ConferenceDB* confDB) const {
    unsigned int refs = 0;
    for (size_t i = 0;i<confDB->talks.Count();++i) {
      PaperTalk* pt = dynamic_cast<PaperTalk*>(confDB->talks.GetEntryByPos(i));
      if (!pt) continue;

      if (pt->GetPaper() == m_iIndex) {
          pt->SetPaper(newPaper);
          ++refs;
      }
    }
    return refs;
}

unsigned int Paper::GetReferenceCount(const ConferenceDB* confDB) const {
  unsigned int refs = 0;
  for (size_t i = 0;i<confDB->talks.Count();++i) {
    const PaperTalk* pt = dynamic_cast<const PaperTalk*>(confDB->talks.GetEntryByPos(i));
    if (!pt) continue;
    
    if (pt->GetPaper() == m_iIndex) refs++;
  }
  return refs;
}
