#ifndef Panel_H
#define Panel_H

#include "OrganizedSession.h"
#include "StringList.h"

class Panel : public OrganizedSession {
public:
    Panel(const std::string& strTitle,
          const int iStartTime,
          const int iEndTime,
          const std::string& strAbstract);
    
    Panel(const std::string& strTitle,
          const int iStartTime,
          const int iEndTime,
          const SciPerson& sessionChair,
          const bool bChairAcceptsMail, 
          const std::string& strAbstract);
    
    Panel(const std::string& strTitle, 
          const int iStartTime,
          const int iEndTime,
          const SciPerson& sessionChair,
          const bool bChairAcceptsMail, 
          const std::string& strAbstract, 
          const std::vector<index_t>& vOrganizers,
          const std::vector<index_t>& vPanelists,
          const std::vector<index_t>& vLocations);
    
    Panel(std::istream& stream);
    
    virtual bool Validate(const ConferenceDB* confDB) const;
    
    const std::vector<index_t>& GetPanelists() const {return m_vPanelists;}
    void SetPanelists(const std::vector<index_t>& vPanelists)  {m_vPanelists = vPanelists;}
    void AddPanelist(const SciPerson& Panelist)  {m_vPanelists.push_back(Panelist.GetIndex());}
    void DelPanelist(index_t index);
    unsigned int ReplacePanelist(const SciPerson& person, const SciPerson& newPerson);

    
    virtual std::string GetSessionType() const {return StringList::strPanel;}    
    static std::string GetClassName() {return "Panel";} 
    virtual std::string GetClassNameViaObject() const {return GetClassName();} 
    
    bool operator==(const Panel &other) const {
      return other.m_vPanelists == m_vPanelists &&
             OrganizedSession::operator==(other);
    }

protected:
    Panel() : OrganizedSession() {}
    
    std::vector<index_t> m_vPanelists;
    
    virtual void SerializeValues(std::string& serializationString) const;
    virtual bool DeserializeValues(std::istream& stream);
    
};


#endif // Panel_H
