#include "Panel.h"
#include "ConferenceDB.h"
#include "StringList.h"

Panel::Panel(const std::string& strTitle,
             const int iStartTime,
             const int iEndTime,
             const std::string& strAbstract) :
OrganizedSession(strTitle,iStartTime,iEndTime,StringList::strPanel, strAbstract)
{
}

Panel::Panel(const std::string& strTitle, 
             const int iStartTime,
             const int iEndTime,
             const SciPerson& sessionChair,
             const bool bChairAcceptsMail,
             const std::string& strAbstract) :
OrganizedSession(strTitle,iStartTime,iEndTime,sessionChair,bChairAcceptsMail, StringList::strPanel, strAbstract)
{
}

Panel::Panel(const std::string& strTitle, 
             const int iStartTime,
             const int iEndTime,
             const SciPerson& sessionChair,
             const bool bChairAcceptsMail, 
             const std::string& strAbstract,
             const std::vector<index_t>& vOrganizers,
             const std::vector<index_t>& vPanelists, 
             const std::vector<index_t>& vLocations) :
OrganizedSession(strTitle,iStartTime,iEndTime,sessionChair,bChairAcceptsMail, StringList::strPanel, strAbstract, vOrganizers, vLocations),
m_vPanelists(vPanelists)
{
}

Panel::Panel(std::istream& stream) :
OrganizedSession()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void Panel::SerializeValues(std::string& serializationString) const {
  OrganizedSession::SerializeValues(serializationString);
  AddVectorSerialization(serializationString, m_vPanelists);
}

bool Panel::DeserializeValues(std::istream& stream) {
  if (!OrganizedSession::DeserializeValues(stream)) return false;
  if (!DeserializeVector(stream, m_vPanelists)) return false;
  return true;
}

void Panel::DelPanelist(index_t index) {
    for (size_t i = 0;i<m_vPanelists.size();++i) {
      if (m_vPanelists[i] == index)
        m_vPanelists.erase(m_vPanelists.begin()+i);
    }
}

unsigned int Panel::ReplacePanelist(const SciPerson& person, const SciPerson& newPerson) {
    unsigned int refs = 0;
    index_t personIndex = person.GetIndex();
    for (size_t i = 0;i<m_vPanelists.size();++i) {
      if (m_vPanelists[i] == personIndex) {
        m_vPanelists[i] = newPerson.GetIndex();
        ++refs;
      }
    }
    return refs;
}

bool Panel::Validate(const ConferenceDB* confDB) const {
  if (! OrganizedSession::Validate(confDB) ) return false;    
  
  for (size_t i = 0;i<m_vPanelists.size();++i) {
    if (! confDB->people.GetEntryByIndex(m_vPanelists[i]) ) return false;
  }  
  return true;
}
