#ifndef ORGANIZEDSESSION_H
#define ORGANIZEDSESSION_H

#include "Session.h"

class OrganizedSession : public Session {
public:
    OrganizedSession(const std::string& strTitle,
                     const int iStartTime,
                     const int iEndTime,
                     const std::string& strSessionDesc,
                     const std::string& strAbstract);

    OrganizedSession(const std::string& strTitle,
                   const int iStartTime,
                   const int iEndTime,
                   const SciPerson& sessionChair,
                   const bool bChairAcceptsMail,
                   const std::string& strSessionDesc, 
                   const std::string& strAbstract);
  
  OrganizedSession(const std::string& strTitle, 
                   const int iStartTime,
                   const int iEndTime,
                   const SciPerson& sessionChair,
                   const bool bChairAcceptsMail,
                   const std::string& strSessionDesc, 
                   const std::string& strAbstract, 
                   const std::vector<index_t>& vOrganizers,
                   const std::vector<index_t>& vLocations);
  
  OrganizedSession(std::istream& stream);
  
  const std::string& GetAbstract() const {return m_strAbstract;}
  void SetAbstract(const std::string& strAbstract)  {m_strAbstract = strAbstract;}

  const std::vector<index_t>& GetOrganizers() const {return m_vOrganizers;}
  void SetOrganizers(const std::vector<index_t>& vOrganizers)  {m_vOrganizers = vOrganizers;}
  void AddOrganizer(const SciPerson& Organizer)  {m_vOrganizers.push_back(Organizer.GetIndex());}
  void DelOrganizer(index_t index);
  unsigned int ReplaceOrganizer(const SciPerson& person, const SciPerson& newPerson);

  virtual bool Validate(const ConferenceDB* confDB) const;
  
  static std::string GetClassName() {return "OrganizedSession";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  
  bool operator==(const OrganizedSession &other) const {
    return other.m_strAbstract == m_strAbstract &&
           other.m_vOrganizers == m_vOrganizers &&
           Session::operator==(other);
  }

protected:
  OrganizedSession() : Session() {}
  
  std::string m_strAbstract;
  std::vector<index_t> m_vOrganizers;
  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};


#endif // ORGANIZEDSESSION_H
