#ifndef KEYNOTE_H
#define KEYNOTE_H

#include "Session.h"
#include "InvitedTalk.h"
#include "StringList.h"

class Keynote : public Session {
public:
    Keynote(const std::string& strTitle,
            const int iStartTime,
            const int iEndTime,
            const bool bIsCapstone);

    Keynote(const std::string& strTitle,
          const int iStartTime,
          const int iEndTime,
          const SciPerson& sessionChair,
          const bool bChairAcceptsMail,
          const bool bIsCapstone);
  
  Keynote(const std::string& strTitle, 
          const int iStartTime,
          const int iEndTime,
          const SciPerson& sessionChair,
          const bool bChairAcceptsMail,
          const bool bIsCapstone, 
          const std::vector<index_t>& vLocations,
          const std::vector<index_t>& vInvitedTalks);
  
  Keynote(std::istream& stream);
  
  const std::vector<index_t>& GetInvitedTalks() const {return m_vInvitedTalks;}
  void SetInvitedTalks(const std::vector<index_t>& vInvitedTalks)  {m_vInvitedTalks = vInvitedTalks;}
  void AddInvitedTalk(const InvitedTalk& InvitedTalk)  {m_vInvitedTalks.push_back(InvitedTalk.GetIndex());}
  void DelInvitedTalk(index_t index);

  bool GetIsCapstone() const {return m_bIsCapstone;}
  void SetIsCapstone(bool bCapstone) {m_bIsCapstone = bCapstone;}  
  
  virtual std::string GetSessionType() const {return (m_bIsCapstone) ? StringList::strCapstone : StringList::strKeynote;}
  static std::string GetClassName() {return "Keynote/Capstone";}
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  
  virtual bool Contains(const Talk* t) const;    
  virtual bool Validate(const ConferenceDB* confDB) const;
  
  bool operator==(const Keynote &other) const {
    return other.m_vInvitedTalks == m_vInvitedTalks &&
           other.m_bIsCapstone == m_bIsCapstone &&
           Session::operator==(other);
  }


protected:
  Keynote() : Session() {}
  
  std::vector<index_t> m_vInvitedTalks;  
  bool m_bIsCapstone;
  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};


#endif // KEYNOTE_H
