#ifndef INVITEDTALK_H
#define INVITEDTALK_H

#include "Talk.h"
#include "Paper.h"

class InvitedTalk : public Talk {
public:
  InvitedTalk(const std::string& strTitle,
              const int iStartTime,
              const int iEndTime,
              const std::string& strAbstract);
  
  InvitedTalk(const std::string& strTitle, 
              const std::vector<index_t>& vSpeakers,
              const int iStartTime,
              const int iEndTime,
              const std::string& strAbstract);
  
  InvitedTalk(std::istream& stream);
  
  const std::string& GetAbstract() const {return m_strAbstract;}  
  void SetAbstract(const std::string& strAbstract)  {m_strAbstract = strAbstract;}
  
  virtual std::string GetTalkType() {return "Invited Talk";}

  static std::string GetClassName() {return "InvitedTalk";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();}   
  virtual bool Validate(const ConferenceDB* confDB) const {return Talk::Validate(confDB);}
  
protected:
  InvitedTalk() : Talk() {}

  std::string m_strAbstract;
  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};


#endif // INVITEDTALK_H