#include "InvitedTalk.h"

InvitedTalk::InvitedTalk(const std::string& strTitle, 
                         const int iStartTime,
                         const int iEndTime,
                         const std::string& strAbstract) :
Talk(strTitle, iStartTime, iEndTime),
m_strAbstract(strAbstract)
{
}

InvitedTalk::InvitedTalk(const std::string& strTitle, 
                         const std::vector<index_t>& vSpeakers,
                         const int iStartTime,
                         const int iEndTime,
                         const std::string& strAbstract) :
Talk(strTitle, vSpeakers, iStartTime, iEndTime),
m_strAbstract(strAbstract)
{
}

InvitedTalk::InvitedTalk(std::istream& stream) :
Talk()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void InvitedTalk::SerializeValues(std::string& serializationString) const {
  Talk::SerializeValues(serializationString);
  AddSerialization(serializationString, m_strAbstract);
}

bool InvitedTalk::DeserializeValues(std::istream& stream) {
  if (!Talk::DeserializeValues(stream)) return false;
  return DeserializeValue(stream, m_strAbstract);
}