#include "Factories.h"

WorkDay* WorkDayFac::Deserialize(std::istream& stream){
  std::string s;
  if(!WorkDay::DeserializeValue(stream, s))
      return NULL;
  if (s == WorkDay::GetClassName()) {
    return new WorkDay(stream);
  }
  return NULL;
}

void WorkDayFac::Serialize(std::string& serializationString, const WorkDay* pWorkDay) {
  Serializable::AddSerialization(serializationString, pWorkDay->GetClassNameViaObject());
  pWorkDay->Serialize(serializationString);
}

Track* TrackFac::Deserialize(std::istream& stream){
  std::string s;
  if(!Track::DeserializeValue(stream, s)) return NULL;
  if (s == Track::GetClassName()) {
    return new Track(stream);
  }
  return NULL;
}

void TrackFac::Serialize(std::string& serializationString, const Track* pTrack) {
  Serializable::AddSerialization(serializationString, pTrack->GetClassNameViaObject());
  pTrack->Serialize(serializationString);
}

#include "Paper.h"
#include "Poster.h"

SciWork* SciWorkFac::Deserialize(std::istream& stream){
  std::string s;
  if(!Serializable::DeserializeValue(stream, s)) return NULL;
  
  if (s == Paper::GetClassName()) {
    return new Paper(stream);
  }

  if (s == Poster::GetClassName()) {
    return new Poster(stream);
  }
    
  return NULL;
}

void SciWorkFac::Serialize(std::string& serializationString, const SciWork* pSciWork) {
  Serializable::AddSerialization(serializationString, pSciWork->GetClassNameViaObject());
  pSciWork->Serialize(serializationString);
}

SciPerson* SciPersonFac::Deserialize(std::istream& stream){
  std::string s;
  if(!Serializable::DeserializeValue(stream, s)) return NULL;
  
  if (s == SciPerson::GetClassName()) {
    return new SciPerson(stream);
  }
  
  return NULL;
}

void SciPersonFac::Serialize(std::string& serializationString, const SciPerson* pSciPerson){
  Serializable::AddSerialization(serializationString, pSciPerson->GetClassNameViaObject());
  pSciPerson->Serialize(serializationString);
}

#include "Keynote.h"
#include "PaperSession.h"
#include "PosterSession.h"
#include "OrganizedSession.h"
#include "Panel.h"
#include "Tutorial.h"

Session* SessionFac::Deserialize(std::istream& stream){
  std::string s;
  if(!Serializable::DeserializeValue(stream, s)) return NULL;

  if (s == PaperSession::GetClassName()) {
    return new PaperSession(stream);
  }

  if (s == PosterSession::GetClassName()) {
    return new PosterSession(stream);
  }

  if (s == Keynote::GetClassName()) {
    return new Keynote(stream);
  }

  if (s == OrganizedSession::GetClassName()) {
    return new OrganizedSession(stream);
  }
  
  if (s == Tutorial::GetClassName()) {
    return new Tutorial(stream);
  }

  if (s == Panel::GetClassName()) {
    return new Panel(stream);
  }
  
  if (s == Session::GetClassName()) {
    return new Session(stream);
  }
  
  return NULL;
}

void SessionFac::Serialize(std::string& serializationString, const Session* pSession){
  Serializable::AddSerialization(serializationString, pSession->GetClassNameViaObject());
  pSession->Serialize(serializationString);
}

#include "PaperTalk.h"
#include "InvitedTalk.h"

Talk* TalkFac::Deserialize(std::istream& stream){
  std::string s;
  if(!Serializable::DeserializeValue(stream, s)) return NULL;

  if (s == PaperTalk::GetClassName()) {
    return new PaperTalk(stream);
  }

  if (s == InvitedTalk::GetClassName()) {
    return new InvitedTalk(stream);
  }

  if (s == Talk::GetClassName()) {
    return new Talk(stream);
  }
 
  return NULL;
}

void TalkFac::Serialize(std::string& serializationString, const Talk* pTalk){
  Serializable::AddSerialization(serializationString, pTalk->GetClassNameViaObject());
  pTalk->Serialize(serializationString);
}

Room* RoomFac::Deserialize(std::istream& stream){
  std::string s;
  if(!Serializable::DeserializeValue(stream, s)) return NULL;
  if (s == Room::GetClassName()) {
    return new Room(stream);
  }
  return NULL;
}

void RoomFac::Serialize(std::string& serializationString, const Room* pRoom){
  Serializable::AddSerialization(serializationString, pRoom->GetClassNameViaObject());
  pRoom->Serialize(serializationString);
}

Building* BuildingFac::Deserialize(std::istream& stream){
  std::string s;
  if(!Serializable::DeserializeValue(stream, s)) return NULL;
  if (s == Building::GetClassName()) {
    return new Building(stream);
  }
  return NULL;
}

void BuildingFac::Serialize(std::string& serializationString, const Building* pBuilding){
  Serializable::AddSerialization(serializationString, pBuilding->GetClassNameViaObject());
  pBuilding->Serialize(serializationString);
}

Affiliation* AffiliationFac::Deserialize(std::istream& stream){
  std::string s;
  if(!Serializable::DeserializeValue(stream, s)) return NULL;
  if (s == Affiliation::GetClassName()) {
    return new Affiliation(stream);
  }
  return NULL;
}

void AffiliationFac::Serialize(std::string& serializationString, const Affiliation* pAffiliation){
  Serializable::AddSerialization(serializationString, pAffiliation->GetClassNameViaObject());
  pAffiliation->Serialize(serializationString);
}
