#include "DemoDBGenerator.h"

#include "Paper.h"
#include "Poster.h"
#include "InvitedTalk.h"
#include "PaperTalk.h"
#include "PaperSession.h"
#include "PosterSession.h"
#include "Tutorial.h"
#include "Panel.h"
#include "Building.h"
#include "Room.h"
#include "Keynote.h"
#include "WorkDay.h"

ConferenceDB* DemoDBGenerator::GenDemoDB(const std::string& strTitle, const std::string& strShortTitle)
{  
  // general conference data
  ConferenceDB* c = new ConferenceDB();
  c->SetTitle(strTitle);
  c->SetShortTitle(strShortTitle);
  c->SetContactMail("jens.krueger@dfki.de");

  // Affiliations
  Affiliation ivda("Interactive Visualization and Data Analysis Group", "66123 Saarbrücken");
  c->affiliations.AddEntry(ivda);
  Affiliation sci("Scientific Computing and Imaging Institute", "Salt Lake City, Utah") ;
  c->affiliations.AddEntry(sci);
  Affiliation dfki("Deutsches Forschungsinstitut für künstliche Inteligenz", "66123 Saarbrücken");
  c->affiliations.AddEntry(dfki);
  Affiliation ivci("Intel Visual Computing Institute", "66123 Saarbrücken");
  c->affiliations.AddEntry(ivci);
  Affiliation tum3d("Chair for Computer Graphics & Visualization, tum3D", "München");
  c->affiliations.AddEntry(tum3d);
  Affiliation kaust("Geometric Modeling and Scientific Visualization Center, King Abdullah University of Science and Technology (KAUST)", "Thuwal 23955-6900, Kingdom of Saudi Arabia");
  c->affiliations.AddEntry(kaust);
  Affiliation fh_reutlingen("Reutlingen University", "Reutlingen, Germany");
  c->affiliations.AddEntry(fh_reutlingen);

  // person db
  SciPerson jens("Jens","Harald", "Krüger", "jens.krueger@dfki.de", "JHKrueger", "http://www.ivda.uni-saarland.de/fileadmin/img/people/thumb_jens_krueger.jpg", "http://www.ivda.uni-saarland.de/index.php?id=6&no_cache=1&tx_ivdapersons_pi1[showUid]=1");
  jens.AddAffiliation(ivda);
  jens.AddAffiliation(sci);
  jens.AddAffiliation(dfki);
  jens.AddAffiliation(ivci);
  c->people.AddEntry(jens);
  SciPerson georg("Georg","","Tamm", "georg.tamm@dfki.de", "", "", "http://www.ivda.uni-saarland.de/index.php?id=6&no_cache=1&tx_ivdapersons_pi1%5BshowUid%5D=2");
  georg.AddAffiliation(ivda);
  georg.AddAffiliation(dfki);
  georg.AddAffiliation(ivci);
  c->people.AddEntry(georg);
  SciPerson juergen("Jürgen","", "Grüninnger", "juergen.gruenninger@dfki.de", "", "http://www.ivda.uni-saarland.de/fileadmin/img/people/thumb_juergen_grueninger.jpg", "");
  juergen.AddAffiliation(ivda);
  juergen.AddAffiliation(ivci);
  c->people.AddEntry(juergen);

  SciPerson jenss("Jens","", "Schneider", "Jens.schneider@KAUST.EDU.SA", "", "http://gmsv.kaust.edu.sa/people/postdoctoral_fellows/schneider/schneider.bmp", "http://gmsv.kaust.edu.sa/people/postdoctoral_fellows/schneider/schneider.html");
  jenss.AddAffiliation(kaust);
  jenss.AddAffiliation(tum3d);
  c->people.AddEntry(jenss);

  SciPerson hilko("Hilko","", "Hoffmann", "hilko.hoffmann@dfki.de", "", "http://viscenter.dfki.de/wp-content/uploads/2011/04/portrait_hilko.jpg", "");
  hilko.AddAffiliation(ivci);
  c->people.AddEntry(hilko);

  SciPerson uwe("Uwe","", "Kloos", "", "", "http://www.inf.reutlingen-university.de/uploads/pics/kloos_01.jpg", "");
  uwe.AddAffiliation(fh_reutlingen);
  c->people.AddEntry(uwe);

  SciPerson tom("Thomas","", "Fogal", "tfogal@sci.utah.edu", "", "", "");
  tom.AddAffiliation(sci);
  c->people.AddEntry(tom);

  SciPerson christian("Christian","", "Dick", "dick@tum.de", "", "http://wwwcg.in.tum.de/people/pics/Dick", "http://wwwcg.in.tum.de/people/Dick");
  christian.AddAffiliation(tum3d);
  c->people.AddEntry(christian);

  SciPerson ruediger("Rüdiger","", "Westermann", "westermann@tum.de", "", "http://wwwcg.in.tum.de/people/pics/Westermann", "http://wwwcg.in.tum.de/people/Westermann");
  ruediger.AddAffiliation(tum3d);
  c->people.AddEntry(ruediger);


  // paper db
  Paper p1("Multi-resolution-Display System for Virtual Reality Setups", "In a number of computing areas today, like simulation or graphic design, image data is provided that contains far more details than computer screens are able to display. Even very common data such as a digital photograph made with a cheap consumer camera exceeded the resolution of most high definition displays. If those or even lower resolution images are used as detail textures in a three dimensional scene the problem becomes even more obvious as those regions normally do not cover the entire display which further reduces the effective resolution. Especially in visualizations of highly detailed scientific datasets this is a non-wanted effect. In most cases, it is not sufficient to simply zoom into a specific region of the data until the screen provides adequate resolution to display the data, as in this situation the context information about this region is lost. Often, however, it is possible to separate the dataset into a number of scales such that a low resolution version of the dataset exists (e.g. a down-sampled version of an image) that gives an overview over the data while more details can be discovered when focusing on just small regions of this overview. These types of data or documents are referred to as ``multi-scale'' documents.\n The multi-scale problem also applies to stereoscopic virtual reality (VR) systems. Especially projection-based systems, where large projection screens and limited projector resolutions are common, show a low level of detail. In extreme cases even the wiring on the projector LCDs are visible in the stereoscopic image which disrupts the feeling of immersion. To counter this, a multi resolution stereo display system consisting of a pair of video projectors, which are controlled by stepper motors has been developed. These projectors display a high-resolution inset into a small portion of the low-resolution image. To avoid crosstalk between the low and high resolution projections, a mask is rendered into the low resolution scene to black out the area on the screen that is covered by the inlay.\n This setup allows the users to display a region of the projection screen in significantly higher resolution, in fact in our proposed setup we achieve resolutions in the inlay that are close to the maximum resolution of the average human eye, at normal working distance. As our system only adds a few components to an existing stereo projection setup it can be installed as an upgrade for many existing projection-based VR systems.", "", "", "http://www.ivda.uni-saarland.de/papers/myfirst.pdf");
  p1.AddAuthor(juergen);
  p1.AddAuthor(hilko);
  p1.AddAuthor(uwe);
  p1.AddAuthor(jens);
  c->works.AddEntry(p1);
  Paper p2("Efficient I/O for Parallel Visualization", "While additional cores and newer architectures, such as those provided by GPU clusters, steadily increase available compute power, memory and disk access has not kept pace, and most believe this trend will continue. It is therefore of critical importance that we design systems and algorithms which make effective use of off-processor storage. This work details our experiences using parallel file systems, details performance using current systems and software, and suggests a new API which has greater potential for increased scalability.", "", "", "http://ivda.cs.uni-saarland.de/fileadmin/publications/protected/2011/EGPGV2011b.pdf");
  p2.AddAuthor(tom);
  p2.AddAuthor(jens);
  c->works.AddEntry(p2);
  Paper p3("A new sampling scheme for slice based volume rendering", "In this paper we present a novel approach to generate proxy geometry for slice based volume rendering. The basic idea is derived from the behavior of a ray-caster and is a simple extension of the well known 2D object-aligned texture stack based technique. From this our novel scheme inherits the advantage that it enables hardware-based volume rendering for devices that do not support 3D textures. On these devices previous object-aligned 2D texture based approaches suffered from disturbing view angle dependent stack-switching artifacts which are avoided by our novel method. Our approach also shows benefits compared to the widely used view aligned slicing algorithm as it avoids jagged boundary artifacts and increases performance.", "", "", "");
  p3.AddAuthor(jens);
  c->works.AddEntry(p3);

  Paper p4("Tuvok - An Architecture for Large Scale Volume Rendering", "In this paper we present the Tuvok architecture, a cross-platform open-source volume rendering system that delivers high quality, state of the art renderings at production level code quality. Due to its progressive rendering algorithm, Tuvok can interactively visualize arbitrarily large data sets even on low-end 32bit systems, though it can also take full advantage of high-end workstations with large amounts of memory and modern GPUs. To achieve this Tuvok uses an optimized out-of-core, bricked, level of detail data representation. From a software development perspective, Tuvok is composed of three independent components, a UI subsystem based on Qt, a rendering subsystem based on OpenGL and DirectX, and an IO subsystem. The IO subsystem not only handles the out-of-core data processing and paging but also includes support for many widely used file formats such as DICOM and ITK volumes. For rendering, Tuvok implements a wide variety of different rendering methods, ranging from 2D texture stack based approaches for low end hardware, to 3D slice based implementations and GPU based ray casters. All of these modes work with one- or multi-dimensional transfer functions, isosurface, and ClearView rendering modes. We also present ImageVis3D, a volume rendering application that uses the Tuvok subsystems. While these features may be found individually in other volume rendering packages, to our best knowledge this is the first open source system to deliver all of these capabilities at once.", "", "http://www.sci.utah.edu/~tfogal/academic/tuvok/rm-260.png", "");
  p4.AddAuthor(tom);
  p4.AddAuthor(jens);
  c->works.AddEntry(p4);

  Paper p5("GPU Ray-Casting for Scalable Terrain Rendering", "With the ever increasing resolution of scanned elevation models, geometry throughput on the GPU is becoming a severe performance limitation in 3D terrain rendering. In this paper, we investigate GPU ray-casting as an alternative to overcome this limitation, and we demonstrate its advanced scalability compared to rasterization-based techniques. By integrating ray-casting into a tile-based GPU viewer that effectively reduces bandwidth requirements in out-of-core terrain visualization, we show that the rendering performance for large, high-resolution terrain fields can be increased significantly. We show that a screen-space error below one pixel permits piecewise constant interpolation of initial height samples. Furthermore, we exploit the texture mapping capabilities on recent GPUs to perform deferred anisotropic texture filtering, which allows for the rendering of digital elevation models and corresponding photo textures. In two key experiments we compare GPU-based ray-casting to a rasterization-based approach in the scope of terrain rendering, and we demonstrate the scalability of the proposed ray-caster with respect to display and data resolution.", "http://wwwcg.in.tum.de/Research/Publications/TerrainRayCasting", "http://wwwcg.in.tum.de/Research/Publications/TerrainRayCasting/Teaser.png", "http://wwwcg.in.tum.de/Research/data/Publications/EG09AreasTerrain.pdf");
  p5.AddAuthor(christian);
  p5.AddAuthor(jens);
  p5.AddAuthor(ruediger);
  c->works.AddEntry(p5);

  // poster db
  Poster poster1("Poster 1", "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet", "http://wwwcg.in.tum.de/Research/Publications/TerrainRayCasting", "http://wwwcg.in.tum.de/Research/Publications/TerrainRayCasting/Teaser.png", "http://wwwcg.in.tum.de/Research/data/Publications/EG09AreasTerrain.pdf");
  poster1.AddAuthor(christian);
  poster1.AddAuthor(jens);
  c->works.AddEntry(poster1);

  Poster poster2("Poster 2", "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet", "http://wwwcg.in.tum.de/Research/Publications/TerrainRayCasting", "http://wwwcg.in.tum.de/Research/Publications/TerrainRayCasting/Teaser.png", "http://wwwcg.in.tum.de/Research/data/Publications/EG09AreasTerrain.pdf");
  poster2.AddAuthor(tom);
  poster2.AddAuthor(ruediger);
  c->works.AddEntry(poster2);

  // talk db
  InvitedTalk talk1("About the beauty of iOS based conference managers", TOD2MINUTES(10,00), TOD2MINUTES(12,15), "In this talk I will present how much fun it was to develop at confernce DB and a viewer app on iOS devices.");
  talk1.AddSpeaker(jens);
  c->talks.AddEntry(talk1);
  PaperTalk talk2(p1.GetTitle(), TOD2MINUTES(11,00), TOD2MINUTES(11,45), p1);
  talk2.AddSpeaker(jens);
  talk2.AddSpeaker(georg);
  c->talks.AddEntry(talk2);
  PaperTalk talk3(p2.GetTitle(), TOD2MINUTES(11,45), TOD2MINUTES(12,30), p2);
  talk3.AddSpeaker(jens);
  c->talks.AddEntry(talk3);
  PaperTalk talk4(p3.GetTitle(), TOD2MINUTES(12,15), TOD2MINUTES(13,00), p3);
  talk4.AddSpeaker(jens);
  c->talks.AddEntry(talk4);
  PaperTalk talk5("Tuvok Fun", TOD2MINUTES(10,30), TOD2MINUTES(11,00), p4);
  talk5.AddSpeaker(jens);
  c->talks.AddEntry(talk5);
  PaperTalk talk6(p5.GetTitle(), TOD2MINUTES(10,30), TOD2MINUTES(11,00), p5);
  talk6.AddSpeaker(tom);
  c->talks.AddEntry(talk6);
  InvitedTalk tutTalk1("GPU Memory Management", TOD2MINUTES(11,00), TOD2MINUTES(11,30), "This talk describes how GPUs manager their memory.");
  tutTalk1.AddSpeaker(jens);
  c->talks.AddEntry(tutTalk1);
  InvitedTalk tutTalk2("GPUs in Visualization", TOD2MINUTES(11,30), TOD2MINUTES(12,30), "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.");
  tutTalk2.AddSpeaker(christian);
  c->talks.AddEntry(tutTalk2);

  // building db
  Building mainb("Main Building", std::make_pair(9.9,8.8));
  mainb.AddFloorplan(Floorplan("Ground level", "MainGround.jpg", 0.5f));
  c->buildings.AddEntry(mainb);
  Building pav1("Pavillion A", std::make_pair(9.9,8.81));
  pav1.AddFloorplan(Floorplan("Ground level", "Pav1Ground.jpg"));
  pav1.AddFloorplan(Floorplan("Second Floor", "Pav1Second.jpg"));
  c->buildings.AddEntry(pav1);
  Building pav2("Pavillion B", std::make_pair(9.9,8.82));
  pav2.AddFloorplan(Floorplan("Ground level", "Pav2Ground.jpg"));
  c->buildings.AddEntry(pav2);

  // room db
  Room mainbr("Aula", 0, mainb, 0.5f, 0.5f);
  c->rooms.AddEntry(mainbr);
  Room pavr1_1("Testroom A",0, pav1, 0.25f, 0.5f);
  c->rooms.AddEntry(pavr1_1);
  Room pavr1_2("Testroom B",1, pav1, 0.5f, 0.25f);
  c->rooms.AddEntry(pavr1_2);
  Room pavr2_1("Testroom A",0, pav2, 0.25f, 0.25f);
  c->rooms.AddEntry(pavr2_1);

  // session db
  PaperSession session1("nonsense session 1", TOD2MINUTES(11,00), TOD2MINUTES(12,30), jenss, true);
  session1.AddRoom(mainbr);
  session1.AddPaperTalk(talk2);
  session1.AddPaperTalk(talk3);
  c->sessions.AddEntry(session1);

  Keynote unusedSession("unused capstone", TOD2MINUTES(11,00), TOD2MINUTES(12,30), jens, true, true);
  c->sessions.AddEntry(unusedSession);

  Keynote session2("nonsense invited talk", TOD2MINUTES(10,00), TOD2MINUTES(12,15), tom, true, false);
  session2.AddRoom(pavr1_1);
  session2.AddRoom(pavr1_2);
  session2.AddInvitedTalk(talk1);
  c->sessions.AddEntry(session2);

  PaperSession session3("nonsense session 2", TOD2MINUTES(12,15), TOD2MINUTES(13,00), christian, true);
  session3.AddRoom(pavr2_1);
  session3.AddPaperTalk(talk4);
  c->sessions.AddEntry(session3);

  PaperSession session4("nonsense session 4", TOD2MINUTES(10,30), TOD2MINUTES(11,00), georg, true);
  session4.AddRoom(mainbr);
  session4.AddPaperTalk(talk5);
  c->sessions.AddEntry(session4);

  Tutorial tut1("Test", TOD2MINUTES(11,00), TOD2MINUTES(12,00), tom, true, "In this tutorial we will talk about \"test\" in very much detail.");
  tut1.AddRoom(mainbr);
  tut1.AddTutorialTalk(tutTalk1);
  tut1.AddTutorialTalk(tutTalk2);
  c->sessions.AddEntry(tut1);

  Tutorial tut2("Another Test", TOD2MINUTES(11,00), TOD2MINUTES(12,00), christian, true, "In this tutorial we will talk about \"test\" in even more detail.");
  tut2.AddOrganizer(christian);
  tut2.AddOrganizer(georg);
  tut2.AddRoom(mainbr);
  c->sessions.AddEntry(tut2);

  Session lunch("Lunch", TOD2MINUTES(12,00), TOD2MINUTES(13,00), "Break");
  lunch.AddRoom(pavr2_1);
  c->sessions.AddEntry(lunch);

  PosterSession posters("Only the best", TOD2MINUTES(13,00), TOD2MINUTES(14,00));
  posters.AddPoster(poster1);
  posters.AddPoster(poster2);
  posters.AddRoom(pavr2_1);
  c->sessions.AddEntry(posters);

  Panel pan1("GPGPU", TOD2MINUTES(13,00), TOD2MINUTES(14,00), jens, true, "General Purpose Computation on Graphics Progessing Units is lots of fun!");
  pan1.AddOrganizer(christian);
  pan1.AddOrganizer(georg);
  pan1.AddPanelist(juergen);
  pan1.AddPanelist(jens);
  pan1.AddRoom(pavr2_1);
  c->sessions.AddEntry(pan1);

  OrganizedSession org1("GPGPU", TOD2MINUTES(14,00), TOD2MINUTES(15,00), jens, false, "BoF", "Let's all meet and talk about why General Purpose Computation on Graphics Progessing Units is so much fun!");
  org1.AddOrganizer(christian);
  org1.AddOrganizer(georg);
  org1.AddRoom(pavr2_1);
  c->sessions.AddEntry(org1);

  Session social("Banquet", TOD2MINUTES(17,00), TOD2MINUTES(19,00), "Social Event");
  social.AddRoom(mainbr);
  social.AddRoom(pavr2_1);
  c->sessions.AddEntry(social);

  // track db
  Track t1_d1("first track");
  t1_d1.AddSession(session1);
  c->tracks.AddEntry(t1_d1);
  Track t2_d1("second track");
  t2_d1.AddSession(session2);
  t2_d1.AddSession(session3);
  c->tracks.AddEntry(t2_d1);
  Track t1_d2("first track second day");
  t1_d2.AddSession(lunch);
  t1_d2.AddSession(session4);
  t1_d2.AddSession(tut1);
  t1_d2.AddSession(pan1);
  t1_d2.AddSession(org1);
  t1_d2.AddSession(social);
  c->tracks.AddEntry(t1_d2);

  Track t2_d2("second track second day");
  t2_d2.AddSession(posters);
  t2_d2.AddSession(tut2);
  c->tracks.AddEntry(t2_d2);

  // days db
  WorkDay day1(28,7,2011);
  day1.AddTrack(t1_d1);
  day1.AddTrack(t2_d1);
  c->days.AddEntry(day1);

  WorkDay day2(2,8,2011);
  day2.AddTrack(t1_d2);
  day2.AddTrack(t2_d2);
  c->days.AddEntry(day2);

  PaperSession session5("Really Cool session", TOD2MINUTES(10,30), TOD2MINUTES(11,00), tom, true);
  session5.AddRoom(mainbr);
  session5.AddPaperTalk(talk6);
  c->sessions.AddEntry(session5);

  Track t3("");
  t3.AddSession(session5);
  c->tracks.AddEntry(t3);

  WorkDay day3(3,8,2011);
  day3.AddTrack(t3);
  c->days.AddEntry(day3);

  if (c->Validate()) {
    return c;
  } else {
    return NULL;
  }

}
