#ifndef CONFERENCEDB_H
#define CONFERENCEDB_H

#include "Factories.h"

#define CONFERENCE_DB_VERSION 1
#define TOD2MINUTES(hours, mins) (hours*60+mins)

class ConferenceDB : public Serializable {
public:

  ConferenceDB();  
  ConferenceDB(const std::string& strFilename);
  
  const std::string& GetFilename() const {return m_strFilename;}
  int GetVersion() const {return m_iVersion;}  
  bool Validate();
  unsigned int RemoveUnusedEntries();

  void SetTitle(const std::string& strTitle) {m_strTitle = strTitle;} 
  const std::string& GetTitle() const {return m_strTitle;}

  void SetShortTitle(const std::string& strTitle) {m_strShortTitle = strTitle;} 
  const std::string& GetShortTitle() const {return m_strShortTitle;}
  
  void SetContactMail(const std::string& strContactMail) {m_strContactMail = strContactMail;} 
  const std::string& GetContactMail() const {return m_strContactMail;}  
    
  const std::string& GetWebUrl() const {return m_strWebUrl;}
  void SetWebUrl(const std::string& strWebUrl) {m_strWebUrl = strWebUrl;}

  const std::string& GetNewsUrl() const {return m_strNewsUrl;}
  void SetNewsUrl(const std::string& strNewsUrl) {m_strNewsUrl = strNewsUrl;}

  const std::string& GetTwitterName() const {return m_strTwitterName;}
  void SetTwitterName(const std::string& strTwitterName) {m_strTwitterName = strTwitterName;}
  
  bool GetSupportsSessionMails() const {return m_bSupportsSessionMails;}
  void SetSupportsSessionMails(bool bSupportsSessionMails) {m_bSupportsSessionMails = bSupportsSessionMails;}
  
  std::vector< std::string > GetSupportFileList();

  IndexTable<WorkDay, WorkDayFac> days;
  IndexTable<Track, TrackFac> tracks;
  IndexTable<SciWork, SciWorkFac> works;
  IndexTable<SciPerson, SciPersonFac> people;
  IndexTable<Affiliation,AffiliationFac> affiliations;
  IndexTable<Talk, TalkFac> talks;

  IndexTable<Session, SessionFac> sessions;
  IndexTable<Room, RoomFac> rooms;
  IndexTable<Building, BuildingFac> buildings;
  
protected:
  int         m_iVersion;
  std::string m_strFilename;
  std::string m_strTitle;
  std::string m_strShortTitle;
  std::string m_strContactMail;
  
  std::string m_strWebUrl;
  std::string m_strNewsUrl;
  std::string m_strTwitterName;
  
  // capabilites
  bool        m_bSupportsSessionMails;

  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
};

#endif // CONFERENCEDB_H
