#include "ConferenceDB.h"

#include <algorithm>

ConferenceDB::ConferenceDB() : 
Serializable(),
m_iVersion(CONFERENCE_DB_VERSION),
m_strFilename(""),
m_strTitle("Unnamed Conference"),
m_strShortTitle("UK"),
m_strContactMail(""),
m_strWebUrl(""),
m_strNewsUrl(""),
m_strTwitterName(""),
m_bSupportsSessionMails(true)
{
}

ConferenceDB::ConferenceDB(const std::string& strFilename) :
Serializable(),
m_iVersion(CONFERENCE_DB_VERSION),
m_strFilename(strFilename),
m_strTitle(""),
m_strShortTitle(""),
m_strContactMail(""),
m_strWebUrl(""),
m_strNewsUrl(""),
m_strTwitterName(""),
m_bSupportsSessionMails(true)
{
  m_bDeserializationSuccess = DeserializeFile(strFilename);
}


void ConferenceDB::SerializeValues(std::string& serializationString) const {
  AddSerialization(serializationString, m_iVersion);
  AddSerialization(serializationString, m_strTitle);  
  AddSerialization(serializationString, m_strShortTitle);  
  AddSerialization(serializationString, m_strContactMail);  
  AddSerialization(serializationString, m_strWebUrl);
  AddSerialization(serializationString, m_strNewsUrl);
  AddSerialization(serializationString, m_strTwitterName);
  AddSerialization(serializationString, m_bSupportsSessionMails);  
  
  days.Serialize(serializationString);
  tracks.Serialize(serializationString);
  talks.Serialize(serializationString);
  works.Serialize(serializationString);
  people.Serialize(serializationString);
  affiliations.Serialize(serializationString);
  sessions.Serialize(serializationString);
  rooms.Serialize(serializationString);
  buildings.Serialize(serializationString);
}


bool ConferenceDB::DeserializeValues(std::istream& stream) {
  if (!DeserializeValue(stream, m_iVersion)) return false;
  if (!DeserializeValue(stream, m_strTitle)) return false;
  if (!DeserializeValue(stream, m_strShortTitle)) return false;
  if (!DeserializeValue(stream, m_strContactMail)) return false;
  if (!DeserializeValue(stream, m_strWebUrl)) return false;
  if (!DeserializeValue(stream, m_strNewsUrl)) return false;
  if (!DeserializeValue(stream, m_strTwitterName)) return false;
  if (!DeserializeValue(stream, m_bSupportsSessionMails)) return false;
  
  if (!days.Deserialize(stream)) return false;
  if (!tracks.Deserialize(stream)) return false;
  if (!talks.Deserialize(stream)) return false;
  if (!works.Deserialize(stream)) return false;
  if (!people.Deserialize(stream)) return false;
  if (!affiliations.Deserialize(stream)) return false;
  if (!sessions.Deserialize(stream)) return false;
  if (!rooms.Deserialize(stream)) return false;
  if (!buildings.Deserialize(stream)) return false;
  return Validate();
}

bool ConferenceDB::Validate() {
  if (!days.Validate(this)) return false;
  if (!tracks.Validate(this)) return false;
  if (!talks.Validate(this)) return false;
  if (!works.Validate(this)) return false;
  if (!people.Validate(this)) return false;
  if (!affiliations.Validate(this)) return false;
  if (!sessions.Validate(this)) return false;
  if (!rooms.Validate(this)) return false;
  if (!buildings.Validate(this)) return false;
  
  return true;
}

unsigned int ConferenceDB::RemoveUnusedEntries() {
  unsigned int iChanged = 0;

  iChanged += days.RemoveUnusedEntries(this);
  iChanged += tracks.RemoveUnusedEntries(this);
  iChanged += talks.RemoveUnusedEntries(this);
  iChanged += works.RemoveUnusedEntries(this);
  iChanged += people.RemoveUnusedEntries(this);
  iChanged += affiliations.RemoveUnusedEntries(this);
  iChanged += sessions.RemoveUnusedEntries(this);
  iChanged += rooms.RemoveUnusedEntries(this);
  iChanged += buildings.RemoveUnusedEntries(this);

  return iChanged;
}

std::vector< std::string > ConferenceDB::GetSupportFileList() {
    std::vector< std::string > files;
    for (size_t i = 0;i<buildings.Count();++i) {
        const Building* building = buildings.GetEntryByPos(i);
        const std::vector<Floorplan>& floorplans = building->GetFloorplans();

        for (size_t j = 0;j<floorplans.size();++j) {

            if (std::find(files.begin(), files.end(), floorplans[j].m_filename) == files.end() )
                files.push_back(floorplans[j].m_filename);
        }

    }
    return files;
}
