#include "Building.h"
#include "ConferenceDB.h"

Building::Building(const std::string& strName,
                   GlobalPosition pos) :
Indexable(),
m_strName(strName),
m_pos(pos)
{
}

Building::Building(const std::string& strName,
                   GlobalPosition pos,
                   const std::vector<Floorplan>& vFloorPlans) :
Indexable(),
m_strName(strName),
m_pos(pos),
m_vFloorPlans(vFloorPlans)
{
}

Building::Building(std::istream& stream) :
Indexable()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void Building::SerializeValues(std::string& serializationString) const {
  Indexable::SerializeValues(serializationString);
  AddSerialization(serializationString, m_strName);
  AddSerialization(serializationString, m_pos.first);
  AddSerialization(serializationString, m_pos.second);
    
  AddSerialization(serializationString, m_vFloorPlans.size());
  for (size_t i = 0;i<m_vFloorPlans.size();++i) {
    AddSerialization(serializationString, m_vFloorPlans[i].m_desc);
    AddSerialization(serializationString, m_vFloorPlans[i].m_filename);
    AddSerialization(serializationString, m_vFloorPlans[i].m_fScale);
  }
}


bool Building::DeserializeValues(std::istream& stream) {
  if (!Indexable::DeserializeValues(stream)) return false;
  if (!DeserializeValue(stream, m_strName)) return false;
  if (!DeserializeValue(stream, m_pos.first)) return false;
  if (!DeserializeValue(stream, m_pos.second)) return false;
  
  size_t iFloorCount=0;
  m_vFloorPlans.clear();
  if (!DeserializeValue(stream, iFloorCount)) return false;
  for (size_t i = 0;i<iFloorCount;++i) {
    std::string desc, filename;
    float scale;
    if (!DeserializeValue(stream, desc)) return false;
    if (!DeserializeValue(stream, filename)) return false;
    if (!DeserializeValue(stream, scale)) return false;
    m_vFloorPlans.push_back(Floorplan(desc, filename, scale));
  }
  
  return true;
}

void Building::DelFloorplan(size_t index, ConferenceDB* confDB)  {
    for (size_t i = 0;i<confDB->rooms.Count();++i) {
      Room* potentialRoom = confDB->rooms.GetEntryByPos(i);
      if (m_iIndex == potentialRoom->GetBuilding() &&
          potentialRoom->GetFloorIndex() > index) {
        potentialRoom->SetFloorIndex(potentialRoom->GetFloorIndex()-1);
      }
    }
    m_vFloorPlans.erase(m_vFloorPlans.begin()+index);
}

unsigned int Building::GetReferenceCount(const ConferenceDB* confDB) const {
  unsigned int refs = 0;
  for (size_t i = 0;i<confDB->rooms.Count();++i) {
    const Room* potentialRoom = confDB->rooms.GetEntryByPos(i);    
    if (m_iIndex == potentialRoom->GetBuilding()) {
      refs++;
    }
  }
  return refs;
}

unsigned int Building::GetFPReferenceCount(const ConferenceDB* confDB, size_t floorplanIndex) const {
  unsigned int refs = 0;
  for (size_t i = 0;i<confDB->rooms.Count();++i) {
    const Room* potentialRoom = confDB->rooms.GetEntryByPos(i);
    if (m_iIndex == potentialRoom->GetBuilding() && potentialRoom->GetFloorIndex() == floorplanIndex) {
      refs++;
    }
  }
  return refs;
}
